/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class ShardNodes {
    private final UUID shardUuid;
    private final Set<String> nodeIdentifiers;

    public ShardNodes(UUID shardUuid, Set<String> nodeIdentifiers) {
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.nodeIdentifiers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(nodeIdentifiers, "nodeIdentifiers is null"));
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public Set<String> getNodeIdentifiers() {
        return this.nodeIdentifiers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShardNodes other = (ShardNodes)obj;
        return Objects.equals(this.shardUuid, other.shardUuid) && Objects.equals(this.nodeIdentifiers, other.nodeIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.shardUuid, this.nodeIdentifiers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuid", (Object)this.shardUuid).add("nodeIdentifiers", this.nodeIdentifiers).toString();
    }
}

