/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.raptor.legacy.metadata.SchemaDao;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.ConnectionException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public final class SchemaDaoUtil {
    private static final Logger log = Logger.get(SchemaDaoUtil.class);

    private SchemaDaoUtil() {
    }

    public static void createTablesWithRetry(Jdbi dbi) {
        Duration delay = new Duration(2.0, TimeUnit.SECONDS);
        while (true) {
            try (Handle handle = dbi.open();){
                SchemaDaoUtil.createTables((SchemaDao)handle.attach(SchemaDao.class));
                return;
            }
            catch (ConnectionException e) {
                log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                SchemaDaoUtil.sleep(delay);
                continue;
            }
            break;
        }
    }

    private static void createTables(SchemaDao dao) {
        dao.createTableDistributions();
        dao.createTableTables();
        dao.createTableColumns();
        dao.createTableViews();
        dao.createTableNodes();
        dao.createTableShards();
        dao.createTableShardNodes();
        dao.createTableExternalBatches();
        dao.createTableTransactions();
        dao.createTableCreatedShards();
        dao.createTableDeletedShards();
        dao.createTableBuckets();
        dao.createTableShardOrganizerJobs();
    }

    private static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

