/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.trino.plugin.raptor.legacy.NodeSupplier;
import io.trino.plugin.raptor.legacy.RaptorBucketFunction;
import io.trino.plugin.raptor.legacy.RaptorBucketedUpdateFunction;
import io.trino.plugin.raptor.legacy.RaptorBucketedUpdateHandle;
import io.trino.plugin.raptor.legacy.RaptorPartitioningHandle;
import io.trino.plugin.raptor.legacy.RaptorSplit;
import io.trino.plugin.raptor.legacy.RaptorUnbucketedUpdateFunction;
import io.trino.plugin.raptor.legacy.RaptorUnbucketedUpdateHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Node;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class RaptorNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeSupplier nodeSupplier;

    @Inject
    public RaptorNodePartitioningProvider(NodeSupplier nodeSupplier) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
    }

    public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioning) {
        if (partitioning instanceof RaptorUnbucketedUpdateHandle) {
            return Optional.empty();
        }
        RaptorPartitioningHandle handle = (RaptorPartitioningHandle)partitioning;
        ImmutableMap nodesById = Maps.uniqueIndex(this.nodeSupplier.getWorkerNodes(), Node::getNodeIdentifier);
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (String nodeIdentifier : handle.getBucketToNode()) {
            Node node = (Node)nodesById.get(nodeIdentifier);
            if (node == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "Node for bucket is offline: " + nodeIdentifier);
            }
            bucketToNode.add((Object)node);
        }
        return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((List)bucketToNode.build()));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorPartitioningHandle partitioning) {
        return value -> ((RaptorSplit)value).getBucketNumber().getAsInt();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorPartitioningHandle partitioning, List<Type> partitionChannelTypes, int bucketCount) {
        if (partitioning instanceof RaptorUnbucketedUpdateHandle) {
            return new RaptorUnbucketedUpdateFunction(bucketCount);
        }
        if (partitioning instanceof RaptorBucketedUpdateHandle) {
            return new RaptorBucketedUpdateFunction();
        }
        return new RaptorBucketFunction(bucketCount, partitionChannelTypes);
    }
}

