/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import io.trino.spi.connector.SchemaTableName;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ViewResult {
    private final SchemaTableName name;
    private final String data;

    public ViewResult(SchemaTableName name, String data) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    public SchemaTableName getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public static class Mapper
    implements RowMapper<ViewResult> {
        public ViewResult map(ResultSet r, StatementContext ctx) throws SQLException {
            SchemaTableName name = new SchemaTableName(r.getString("schema_name"), r.getString("table_name"));
            return new ViewResult(name, r.getString("data"));
        }
    }
}

