/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.raptor.legacy.metadata.ColumnStats;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;

public class ShardInfo {
    private final UUID shardUuid;
    private final OptionalInt bucketNumber;
    private final Set<String> nodeIdentifiers;
    private final List<ColumnStats> columnStats;
    private final long rowCount;
    private final long compressedSize;
    private final long uncompressedSize;
    private final long xxhash64;

    @JsonCreator
    public ShardInfo(@JsonProperty(value="shardUuid") UUID shardUuid, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="nodeIdentifiers") Set<String> nodeIdentifiers, @JsonProperty(value="columnStats") List<ColumnStats> columnStats, @JsonProperty(value="rowCount") long rowCount, @JsonProperty(value="compressedSize") long compressedSize, @JsonProperty(value="uncompressedSize") long uncompressedSize, @JsonProperty(value="xxhash64") long xxhash64) {
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.nodeIdentifiers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(nodeIdentifiers, "nodeIdentifiers is null"));
        this.columnStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnStats, "columnStats is null"));
        Preconditions.checkArgument((rowCount >= 0L ? 1 : 0) != 0, (Object)"rowCount must be positive");
        Preconditions.checkArgument((compressedSize >= 0L ? 1 : 0) != 0, (Object)"compressedSize must be positive");
        Preconditions.checkArgument((uncompressedSize >= 0L ? 1 : 0) != 0, (Object)"uncompressedSize must be positive");
        this.rowCount = rowCount;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.xxhash64 = xxhash64;
    }

    @JsonProperty
    public UUID getShardUuid() {
        return this.shardUuid;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public Set<String> getNodeIdentifiers() {
        return this.nodeIdentifiers;
    }

    @JsonProperty
    public List<ColumnStats> getColumnStats() {
        return this.columnStats;
    }

    @JsonProperty
    public long getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public long getCompressedSize() {
        return this.compressedSize;
    }

    @JsonProperty
    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    @JsonProperty
    public long getXxhash64() {
        return this.xxhash64;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuid", (Object)this.shardUuid).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).add("nodeIdentifiers", this.nodeIdentifiers).add("columnStats", this.columnStats).add("rowCount", this.rowCount).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).add("xxhash64", (Object)String.format("%016x", this.xxhash64)).omitNullValues().toString();
    }
}

