/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;

public class PrimaryKey {
    private final Object[] _values;

    public PrimaryKey(Object[] values) {
        this._values = values;
    }

    public Object[] getValues() {
        return this._values;
    }

    public byte[] asBytes() {
        if (this._values.length == 1) {
            return this.asBytesSingleVal(this._values[0]);
        }
        int sizeInBytes = 0;
        byte[][] cache = new byte[this._values.length][];
        for (int i = 0; i < this._values.length; ++i) {
            Object value = this._values[i];
            if (value instanceof Integer) {
                sizeInBytes += 4;
                continue;
            }
            if (value instanceof Long) {
                sizeInBytes += 8;
                continue;
            }
            if (value instanceof String) {
                cache[i] = ((String)value).getBytes(StandardCharsets.UTF_8);
                sizeInBytes += cache[i].length + 4;
                continue;
            }
            if (value instanceof ByteArray) {
                cache[i] = ((ByteArray)value).getBytes();
                sizeInBytes += cache[i].length + 4;
                continue;
            }
            if (value instanceof Float) {
                sizeInBytes += 4;
                continue;
            }
            if (value instanceof Double) {
                sizeInBytes += 8;
                continue;
            }
            if (value instanceof BigDecimal) {
                cache[i] = BigDecimalUtils.serialize((BigDecimal)value);
                sizeInBytes += cache[i].length + 4;
                continue;
            }
            throw new IllegalStateException(String.format("Unsupported value: %s of type: %s", value, value != null ? value.getClass() : null));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(sizeInBytes);
        for (int i = 0; i < this._values.length; ++i) {
            Object value = this._values[i];
            if (value instanceof Integer) {
                byteBuffer.putInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                byteBuffer.putLong((Long)value);
                continue;
            }
            if (value instanceof Float) {
                byteBuffer.putFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                byteBuffer.putDouble((Double)value);
                continue;
            }
            byteBuffer.putInt(cache[i].length);
            byteBuffer.put(cache[i]);
        }
        return byteBuffer.array();
    }

    private byte[] asBytesSingleVal(Object value) {
        if (value instanceof Integer) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.putInt((Integer)value);
            return byteBuffer.array();
        }
        if (value instanceof Long) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putLong((Long)value);
            return byteBuffer.array();
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof ByteArray) {
            return ((ByteArray)value).getBytes();
        }
        if (value instanceof Float) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.putFloat(((Float)value).floatValue());
            return byteBuffer.array();
        }
        if (value instanceof Double) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putDouble((Double)value);
            return byteBuffer.array();
        }
        if (value instanceof BigDecimal) {
            return BigDecimalUtils.serialize((BigDecimal)value);
        }
        throw new IllegalStateException(String.format("Unsupported value: %s of type: %s", value, value != null ? value.getClass() : null));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PrimaryKey) {
            PrimaryKey that = (PrimaryKey)obj;
            return Arrays.equals(this._values, that._values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._values);
    }

    public String toString() {
        return Arrays.toString(this._values);
    }
}

