/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeGranularitySpec
implements Serializable {
    private static final int DEFAULT_TIME_UNIT_SIZE = 1;
    private static final String DEFAULT_TIME_FORMAT = TimeFormat.EPOCH.toString();
    private static final String COLON_SEPARATOR = ":";
    private String _name;
    private FieldSpec.DataType _dataType;
    private TimeUnit _timeType;
    private int _timeUnitSize = 1;
    private String _timeFormat = DEFAULT_TIME_FORMAT;

    public TimeGranularitySpec() {
    }

    public TimeGranularitySpec(FieldSpec.DataType dataType, TimeUnit timeType, String name) {
        Preconditions.checkNotNull((Object)((Object)timeType));
        Preconditions.checkNotNull((Object)name);
        this._dataType = dataType;
        this._timeType = timeType;
        this._name = name;
    }

    public TimeGranularitySpec(FieldSpec.DataType dataType, TimeUnit timeType, String timeFormat, String name) {
        Preconditions.checkNotNull((Object)((Object)timeType));
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)timeFormat);
        Preconditions.checkArgument((timeFormat.equals(TimeFormat.EPOCH.toString()) || timeFormat.startsWith(TimeFormat.SIMPLE_DATE_FORMAT.toString()) ? 1 : 0) != 0);
        this._dataType = dataType;
        this._timeType = timeType;
        this._name = name;
        this._timeFormat = timeFormat;
    }

    public TimeGranularitySpec(FieldSpec.DataType dataType, int timeUnitSize, TimeUnit timeType, String name) {
        Preconditions.checkNotNull((Object)((Object)timeType));
        Preconditions.checkNotNull((Object)name);
        this._dataType = dataType;
        this._timeType = timeType;
        this._timeUnitSize = timeUnitSize;
        this._name = name;
    }

    public TimeGranularitySpec(FieldSpec.DataType dataType, int timeUnitSize, TimeUnit timeType, String timeFormat, String name) {
        Preconditions.checkNotNull((Object)((Object)timeType));
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)timeFormat);
        Preconditions.checkArgument((timeFormat.equals(TimeFormat.EPOCH.toString()) || timeFormat.startsWith(TimeFormat.SIMPLE_DATE_FORMAT.toString()) ? 1 : 0) != 0);
        this._dataType = dataType;
        this._timeType = timeType;
        this._timeUnitSize = timeUnitSize;
        this._name = name;
        this._timeFormat = timeFormat;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public FieldSpec.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(FieldSpec.DataType dataType) {
        this._dataType = dataType;
    }

    public TimeUnit getTimeType() {
        return this._timeType;
    }

    public void setTimeType(TimeUnit timeType) {
        this._timeType = timeType;
    }

    public int getTimeUnitSize() {
        return this._timeUnitSize;
    }

    public void setTimeUnitSize(int timeUnitSize) {
        Preconditions.checkArgument((timeUnitSize > 0 ? 1 : 0) != 0);
        this._timeUnitSize = timeUnitSize;
    }

    public void setTimeunitSize(int timeUnitSize) {
        Preconditions.checkArgument((timeUnitSize > 0 ? 1 : 0) != 0);
        this._timeUnitSize = timeUnitSize;
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this._timeFormat = timeFormat;
    }

    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("name", this._name);
        jsonObject.put("dataType", this._dataType.name());
        jsonObject.put("timeType", this._timeType.name());
        if (this._timeUnitSize != 1) {
            jsonObject.put("timeUnitSize", this._timeUnitSize);
        }
        if (!this._timeFormat.equals(DEFAULT_TIME_FORMAT)) {
            jsonObject.put("timeFormat", this._timeFormat);
        }
        return jsonObject;
    }

    public String toString() {
        return "< field name: " + this._name + ", data type: " + this._dataType + ", time type: " + this._timeType + ", time unit size: " + this._timeUnitSize + ", time format: " + this._timeFormat + " >";
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        TimeGranularitySpec that = (TimeGranularitySpec)o;
        return EqualityUtils.isEqual(this._name, that._name) && EqualityUtils.isEqual((Object)this._dataType, (Object)that._dataType) && EqualityUtils.isEqual((Object)this._timeType, (Object)that._timeType) && EqualityUtils.isEqual(this._timeUnitSize, that._timeUnitSize) && EqualityUtils.isEqual(this._timeFormat, that._timeFormat);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._name);
        result = EqualityUtils.hashCodeOf(result, (Object)this._dataType);
        result = EqualityUtils.hashCodeOf(result, (Object)this._timeType);
        result = EqualityUtils.hashCodeOf(result, this._timeUnitSize);
        result = EqualityUtils.hashCodeOf(result, this._timeFormat);
        return result;
    }

    @Deprecated
    public static enum TimeFormat {
        EPOCH,
        SIMPLE_DATE_FORMAT;

    }
}

