/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.crypt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.spi.crypt.NoOpPinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotCrypterFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotCrypterFactory.class);
    private static Map<String, PinotCrypter> _crypterMap = new HashMap<String, PinotCrypter>();
    private static final String NOOP_PINOT_CRYPTER = "nooppinotcrypter";
    private static final String CLASS = "class";

    private PinotCrypterFactory() {
    }

    public static void init(PinotConfiguration config) {
        PinotConfiguration schemesConfig = config.subset(CLASS);
        List<String> schemes = schemesConfig.getKeys();
        if (!schemes.isEmpty()) {
            LOGGER.info("Did not find any crypter classes in the configuration");
        }
        for (String scheme : schemes) {
            String className = schemesConfig.getProperty(scheme);
            LOGGER.info("Got crypter class name {}, full crypter path {}, starting to initialize", (Object)scheme, (Object)className);
            try {
                PinotCrypter pinotCrypter = (PinotCrypter)PluginManager.get().createInstance(className);
                pinotCrypter.init(config.subset(scheme));
                LOGGER.info("Initializing PinotCrypter for scheme {}, classname {}", (Object)scheme, (Object)className);
                _crypterMap.put(scheme.toLowerCase(), pinotCrypter);
            }
            catch (Exception e) {
                LOGGER.error("Could not instantiate crypter for class {}", (Object)className, (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (!_crypterMap.containsKey(NOOP_PINOT_CRYPTER)) {
            LOGGER.info("NoOpPinotCrypter not configured, adding as default");
            _crypterMap.put(NOOP_PINOT_CRYPTER, new NoOpPinotCrypter());
        }
    }

    public static PinotCrypter create(String crypterClassName) {
        PinotCrypter pinotCrypter = _crypterMap.get(crypterClassName.toLowerCase());
        if (pinotCrypter == null) {
            throw new RuntimeException("Pinot crypter not configured for class name: " + crypterClassName);
        }
        return pinotCrypter;
    }
}

