/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class ColumnPartitionConfig
extends BaseJsonConfig {
    private final String _functionName;
    private final int _numPartitions;
    private final Map<String, String> _functionConfig;

    public ColumnPartitionConfig(String functionName, int numPartitions) {
        this(functionName, numPartitions, null);
    }

    @JsonCreator
    public ColumnPartitionConfig(@JsonProperty(value="functionName", required=true) String functionName, @JsonProperty(value="numPartitions", required=true) int numPartitions, @JsonProperty(value="functionConfig") @Nullable Map<String, String> functionConfig) {
        Preconditions.checkArgument((functionName != null ? 1 : 0) != 0, (Object)"'functionName' must be configured");
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"'numPartitions' must be positive");
        this._functionName = functionName;
        this._numPartitions = numPartitions;
        this._functionConfig = functionConfig;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    @Nullable
    public Map<String, String> getFunctionConfig() {
        return this._functionConfig;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }
}

