/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class BloomFilterConfig
extends BaseJsonConfig {
    public static final double DEFAULT_FPP = 0.05;
    private final double _fpp;
    private final int _maxSizeInBytes;
    private final boolean _loadOnHeap;

    @JsonCreator
    public BloomFilterConfig(@JsonProperty(value="fpp") double fpp, @JsonProperty(value="maxSizeInBytes") int maxSizeInBytes, @JsonProperty(value="loadOnHeap") boolean loadOnHeap) {
        if (fpp != 0.0) {
            Preconditions.checkArgument((fpp > 0.0 && fpp < 1.0 ? 1 : 0) != 0, (String)"Invalid fpp (false positive probability): %s", (Object)fpp);
            this._fpp = fpp;
        } else {
            this._fpp = 0.05;
        }
        this._maxSizeInBytes = maxSizeInBytes;
        this._loadOnHeap = loadOnHeap;
    }

    public double getFpp() {
        return this._fpp;
    }

    public int getMaxSizeInBytes() {
        return this._maxSizeInBytes;
    }

    public boolean isLoadOnHeap() {
        return this._loadOnHeap;
    }
}

