/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.callback;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncRetryCallContext;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkAsyncRetryThread
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger(ZkAsyncRetryThread.class);
    private BlockingQueue<ZkAsyncRetryCallContext> _retryContexts = new LinkedBlockingQueue<ZkAsyncRetryCallContext>();
    private volatile boolean _isReady = true;

    public ZkAsyncRetryThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-AsyncCallback-Retry-" + this.getId() + "-" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting ZkClient AsyncCallback retry thread.");
        block8: while (true) {
            try {
                while (!this.isInterrupted()) {
                    ZkAsyncRetryCallContext context = this._retryContexts.take();
                    try {
                        context.doRetry();
                        continue block8;
                    }
                    catch (InterruptedException | ZkInterruptedException e) {
                        context.cancel();
                        this.interrupt();
                    }
                    catch (Throwable e) {
                        LOG.error("Error retrying callback {}, cancelling it", (Object)context, (Object)e);
                        context.cancel();
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                LOG.info("ZkClient AsyncCallback retry thread is interrupted.");
                break;
            }
        }
        ZkAsyncRetryThread zkAsyncRetryThread = this;
        synchronized (zkAsyncRetryThread) {
            this._isReady = false;
            for (ZkAsyncRetryCallContext context : this._retryContexts) {
                context.cancel();
            }
        }
        LOG.info("Terminate ZkClient AsyncCallback retry thread.");
    }

    synchronized boolean sendRetryRequest(ZkAsyncRetryCallContext context) {
        if (this._isReady) {
            this._retryContexts.add(context);
            return true;
        }
        return false;
    }
}

