/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.utils.Pairs;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.PinotSqlType;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.apache.pinot.sql.parsers.parser.SqlInsertFromFile;
import org.apache.pinot.sql.parsers.parser.SqlParserImpl;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteSqlParser {
    public static final List<QueryRewriter> QUERY_REWRITERS = new ArrayList<QueryRewriter>(QueryRewriterFactory.getQueryRewriters());
    private static final Logger LOGGER = LoggerFactory.getLogger(CalciteSqlParser.class);
    private static final Pattern OPTIONS_REGEX_PATTEN = Pattern.compile("\\s*option\\s*\\(([^\\)]+)\\)\\s*\\Z", 2);

    private CalciteSqlParser() {
    }

    private static String removeTerminatingSemicolon(String sql) {
        int sqlLength;
        if ((sql = sql.trim()).charAt((sqlLength = sql.length()) - 1) == ';') {
            return sql.substring(0, sqlLength - 1);
        }
        return sql;
    }

    public static SqlNodeAndOptions compileToSqlNodeAndOptions(String sql) throws SqlCompilationException {
        long parseStartTimeNs = System.nanoTime();
        sql = CalciteSqlParser.removeComments(sql);
        List<String> options = CalciteSqlParser.extractOptionsFromSql(sql = CalciteSqlParser.removeTerminatingSemicolon(sql));
        if (!options.isEmpty()) {
            sql = CalciteSqlParser.removeOptionsFromSql(sql);
        }
        StringReader inStream = new StringReader(sql);
        try {
            SqlParserImpl sqlParser = CalciteSqlParser.newSqlParser(inStream);
            SqlNodeList sqlNodeList = sqlParser.SqlStmtsEof();
            SqlNodeAndOptions sqlNodeAndOptions = CalciteSqlParser.extractSqlNodeAndOptions(sql, sqlNodeList);
            if (options.size() > 0) {
                sqlNodeAndOptions.setExtraOptions(CalciteSqlParser.extractOptionsMap(options));
            }
            sqlNodeAndOptions.setParseTimeNs(System.nanoTime() - parseStartTimeNs);
            SqlNodeAndOptions sqlNodeAndOptions2 = sqlNodeAndOptions;
            inStream.close();
            return sqlNodeAndOptions2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new SqlCompilationException("Caught exception while parsing query: " + sql, e);
            }
        }
    }

    @VisibleForTesting
    static SqlNodeAndOptions extractSqlNodeAndOptions(String sql, SqlNodeList sqlNodeList) {
        PinotSqlType sqlType = null;
        SqlNode statementNode = null;
        HashMap<String, String> options = new HashMap<String, String>();
        for (SqlNode sqlNode : sqlNodeList) {
            if (sqlNode instanceof SqlInsertFromFile) {
                if (sqlType == null) {
                    sqlType = PinotSqlType.DML;
                    statementNode = sqlNode;
                    continue;
                }
                throw new SqlCompilationException("SqlNode with executable statement already exist with type: " + sqlType);
            }
            if (sqlNode instanceof SqlSetOption) {
                List operandList = ((SqlSetOption)sqlNode).getOperandList();
                SqlIdentifier key = (SqlIdentifier)operandList.get(1);
                SqlLiteral value = (SqlLiteral)operandList.get(2);
                options.put(key.getSimple(), value.toValue());
                continue;
            }
            if (sqlType == null) {
                sqlType = PinotSqlType.DQL;
                statementNode = sqlNode;
                continue;
            }
            throw new SqlCompilationException("SqlNode with executable statement already exist with type: " + sqlType);
        }
        if (sqlType == null) {
            throw new SqlCompilationException("SqlNode with executable statement not found!");
        }
        return new SqlNodeAndOptions(statementNode, sqlType, QueryOptionsUtils.resolveCaseInsensitiveOptions(options));
    }

    public static PinotQuery compileToPinotQuery(String sql) throws SqlCompilationException {
        return CalciteSqlParser.compileToPinotQuery(CalciteSqlParser.compileToSqlNodeAndOptions(sql));
    }

    public static PinotQuery compileToPinotQuery(SqlNodeAndOptions sqlNodeAndOptions) {
        PinotQuery pinotQuery = CalciteSqlParser.compileSqlNodeToPinotQuery(sqlNodeAndOptions.getSqlNode());
        Map<String, String> options = sqlNodeAndOptions.getOptions();
        if (!options.isEmpty()) {
            pinotQuery.setQueryOptions(options);
        }
        return pinotQuery;
    }

    static void validate(PinotQuery pinotQuery) throws SqlCompilationException {
        CalciteSqlParser.validateGroupByClause(pinotQuery);
        CalciteSqlParser.validateDistinctQuery(pinotQuery);
    }

    private static void validateGroupByClause(PinotQuery pinotQuery) throws SqlCompilationException {
        boolean hasGroupByClause = pinotQuery.getGroupByList() != null;
        HashSet<Expression> groupByExprs = hasGroupByClause ? new HashSet<Expression>(pinotQuery.getGroupByList()) : null;
        int aggregateExprCount = 0;
        for (Expression selectExpression : pinotQuery.getSelectList()) {
            if (CalciteSqlParser.isAggregateExpression(selectExpression)) {
                ++aggregateExprCount;
                continue;
            }
            if (!hasGroupByClause || !CalciteSqlParser.expressionOutsideGroupByList(selectExpression, groupByExprs)) continue;
            throw new SqlCompilationException("'" + RequestUtils.prettyPrint(selectExpression) + "' should appear in GROUP BY clause.");
        }
        int nonAggregateExprCount = pinotQuery.getSelectListSize() - aggregateExprCount;
        if (!hasGroupByClause && aggregateExprCount > 0 && nonAggregateExprCount > 0) {
            throw new SqlCompilationException("Columns and Aggregate functions can't co-exist without GROUP BY clause");
        }
        if (hasGroupByClause) {
            for (Expression groupByExpression : pinotQuery.getGroupByList()) {
                if (!CalciteSqlParser.isAggregateExpression(groupByExpression)) continue;
                throw new SqlCompilationException("Aggregate expression '" + RequestUtils.prettyPrint(groupByExpression) + "' is not allowed in GROUP BY clause.");
            }
        }
    }

    private static void validateDistinctQuery(PinotQuery pinotQuery) throws SqlCompilationException {
        Function function;
        List<Expression> selectList = pinotQuery.getSelectList();
        if (selectList.size() == 1 && (function = selectList.get(0).getFunctionCall()) != null && function.getOperator().equals("distinct")) {
            if (CollectionUtils.isNotEmpty(pinotQuery.getGroupByList())) {
                throw new IllegalStateException("DISTINCT with GROUP BY is currently not supported");
            }
            if (pinotQuery.getLimit() <= 0) {
                throw new IllegalStateException("DISTINCT must have positive LIMIT");
            }
            List<Expression> orderByList = pinotQuery.getOrderByList();
            if (orderByList != null) {
                List<Expression> distinctExpressions = CalciteSqlParser.getAliasLeftExpressionsFromDistinctExpression(function);
                for (Expression orderByExpression : orderByList) {
                    if (distinctExpressions.contains(orderByExpression.getFunctionCall().getOperands().get(0))) continue;
                    throw new IllegalStateException("ORDER-BY columns should be included in the DISTINCT columns");
                }
            }
        }
    }

    private static List<Expression> getAliasLeftExpressionsFromDistinctExpression(Function function) {
        List<Expression> operands = function.getOperands();
        ArrayList<Expression> expressions = new ArrayList<Expression>(operands.size());
        for (Expression operand : operands) {
            if (CalciteSqlParser.isAsFunction(operand)) {
                expressions.add(operand.getFunctionCall().getOperands().get(0));
                continue;
            }
            expressions.add(operand);
        }
        return expressions;
    }

    private static boolean expressionOutsideGroupByList(Expression expr, Set<Expression> groupByExprs) {
        if (expr.getType() == ExpressionType.LITERAL || CalciteSqlParser.isAggregateExpression(expr) || groupByExprs.contains(expr)) {
            return false;
        }
        Function function = expr.getFunctionCall();
        if (function != null) {
            if (function.getOperator().equals("as")) {
                return CalciteSqlParser.expressionOutsideGroupByList(function.getOperands().get(0), groupByExprs);
            }
            return function.getOperands().stream().anyMatch(e -> CalciteSqlParser.expressionOutsideGroupByList(e, groupByExprs));
        }
        return true;
    }

    public static boolean isAggregateExpression(Expression expression) {
        Function functionCall = expression.getFunctionCall();
        if (functionCall != null) {
            String operator = functionCall.getOperator();
            if (AggregationFunctionType.isAggregationFunction((String)operator)) {
                return true;
            }
            if (functionCall.getOperandsSize() > 0) {
                for (Expression operand : functionCall.getOperands()) {
                    if (!CalciteSqlParser.isAggregateExpression(operand)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAsFunction(Expression expression) {
        Function function = expression.getFunctionCall();
        return function != null && function.getOperator().equals("as");
    }

    public static Set<String> extractIdentifiers(List<Expression> expressions, boolean excludeAs) {
        HashSet<String> identifiers = new HashSet<String>();
        for (Expression expression : expressions) {
            Identifier identifier = expression.getIdentifier();
            if (identifier != null) {
                identifiers.add(identifier.getName());
                continue;
            }
            Function function = expression.getFunctionCall();
            if (function == null) continue;
            if (excludeAs && function.getOperator().equals("as")) {
                identifiers.addAll(CalciteSqlParser.extractIdentifiers(new ArrayList<Expression>(Collections.singletonList(function.getOperands().get(0))), true));
                continue;
            }
            identifiers.addAll(CalciteSqlParser.extractIdentifiers(function.getOperands(), excludeAs));
        }
        return identifiers;
    }

    public static Expression compileToExpression(String expression) {
        SqlNode sqlNode;
        try (StringReader inStream = new StringReader(expression);){
            SqlParserImpl sqlParser = CalciteSqlParser.newSqlParser(inStream);
            sqlNode = sqlParser.parseSqlExpressionEof();
        }
        catch (Throwable e) {
            throw new SqlCompilationException("Caught exception while parsing expression: " + expression, e);
        }
        return CalciteSqlParser.toExpression(sqlNode);
    }

    @VisibleForTesting
    static SqlParserImpl newSqlParser(StringReader inStream) {
        SqlParserImpl sqlParser = new SqlParserImpl(inStream);
        sqlParser.switchTo(SqlAbstractParserImpl.LexicalState.DQID);
        sqlParser.setConformance((SqlConformance)SqlConformanceEnum.BABEL);
        sqlParser.setTabSize(1);
        sqlParser.setQuotedCasing(Casing.UNCHANGED);
        sqlParser.setUnquotedCasing(Casing.UNCHANGED);
        sqlParser.setIdentifierMaxLength(128);
        return sqlParser;
    }

    public static PinotQuery compileSqlNodeToPinotQuery(SqlNode sqlNode) {
        SqlNode offsetNode;
        SqlNode limitNode;
        SqlNodeList orderByNodeList;
        SqlNode havingNode;
        SqlNodeList groupByNodeList;
        SqlNode whereNode;
        SqlSelect selectNode;
        PinotQuery pinotQuery = new PinotQuery();
        if (sqlNode instanceof SqlExplain) {
            sqlNode = ((SqlExplain)sqlNode).getExplicandum();
            pinotQuery.setExplain(true);
        }
        if (sqlNode instanceof SqlOrderBy) {
            SqlOrderBy orderByNode = (SqlOrderBy)sqlNode;
            selectNode = (SqlSelect)orderByNode.query;
            selectNode.setOrderBy(orderByNode.orderList);
            selectNode.setFetch(orderByNode.fetch);
            selectNode.setOffset(orderByNode.offset);
        } else {
            selectNode = (SqlSelect)sqlNode;
        }
        if (selectNode.getModifierNode(SqlSelectKeyword.DISTINCT) != null) {
            if (selectNode.getGroup() != null) {
                throw new SqlCompilationException("DISTINCT with GROUP BY is not supported");
            }
            pinotQuery.setSelectList(CalciteSqlParser.convertDistinctSelectList(selectNode.getSelectList()));
        } else {
            pinotQuery.setSelectList(CalciteSqlParser.convertSelectList(selectNode.getSelectList()));
        }
        SqlNode fromNode = selectNode.getFrom();
        if (fromNode != null) {
            DataSource dataSource = new DataSource();
            dataSource.setTableName(fromNode.toString());
            pinotQuery.setDataSource(dataSource);
            if (fromNode instanceof SqlSelect || fromNode instanceof SqlOrderBy) {
                dataSource.setSubquery(CalciteSqlParser.compileSqlNodeToPinotQuery(fromNode));
            }
        }
        if ((whereNode = selectNode.getWhere()) != null) {
            pinotQuery.setFilterExpression(CalciteSqlParser.toExpression(whereNode));
        }
        if ((groupByNodeList = selectNode.getGroup()) != null) {
            pinotQuery.setGroupByList(CalciteSqlParser.convertSelectList(groupByNodeList));
        }
        if ((havingNode = selectNode.getHaving()) != null) {
            pinotQuery.setHavingExpression(CalciteSqlParser.toExpression(havingNode));
        }
        if ((orderByNodeList = selectNode.getOrderList()) != null) {
            pinotQuery.setOrderByList(CalciteSqlParser.convertOrderByList(orderByNodeList));
        }
        if ((limitNode = selectNode.getFetch()) != null) {
            pinotQuery.setLimit(((SqlNumericLiteral)limitNode).intValue(false));
        }
        if ((offsetNode = selectNode.getOffset()) != null) {
            pinotQuery.setOffset(((SqlNumericLiteral)offsetNode).intValue(false));
        }
        CalciteSqlParser.queryRewrite(pinotQuery);
        return pinotQuery;
    }

    private static void queryRewrite(PinotQuery pinotQuery) {
        for (QueryRewriter queryRewriter : QUERY_REWRITERS) {
            pinotQuery = queryRewriter.rewrite(pinotQuery);
        }
        CalciteSqlParser.validate(pinotQuery);
    }

    @Deprecated
    private static List<String> extractOptionsFromSql(String sql) {
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        while (matcher.find()) {
            results.add(matcher.group(1));
        }
        return results;
    }

    @Deprecated
    private static String removeOptionsFromSql(String sql) {
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        return matcher.replaceAll("");
    }

    @Deprecated
    private static Map<String, String> extractOptionsMap(List<String> optionsStatements) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String optionsStatement : optionsStatements) {
            for (String option : optionsStatement.split(",")) {
                String[] splits = option.split("=");
                if (splits.length != 2) {
                    throw new SqlCompilationException("OPTION statement requires two parts separated by '='");
                }
                options.put(splits[0].trim(), splits[1].trim());
            }
        }
        return options;
    }

    @VisibleForTesting
    static String removeComments(String sql) {
        boolean openSingleQuote = false;
        boolean openDoubleQuote = false;
        boolean commented = false;
        boolean singleLineCommented = false;
        boolean multiLineCommented = false;
        int commentStartIndex = -1;
        ArrayList<Pairs.IntPair> commentedParts = new ArrayList<Pairs.IntPair>();
        int length = sql.length();
        block8: for (int index = 0; index < length; ++index) {
            switch (sql.charAt(index)) {
                case '\'': {
                    if (commented || openDoubleQuote) continue block8;
                    openSingleQuote = !openSingleQuote;
                    continue block8;
                }
                case '\"': {
                    if (commented || openSingleQuote) continue block8;
                    openDoubleQuote = !openDoubleQuote;
                    continue block8;
                }
                case '-': {
                    if (commented || openSingleQuote || openDoubleQuote || index >= length - 1 || sql.charAt(index + 1) != '-') continue block8;
                    commented = true;
                    singleLineCommented = true;
                    commentStartIndex = index++;
                    continue block8;
                }
                case '\n': {
                    if (!singleLineCommented) continue block8;
                    commentedParts.add(new Pairs.IntPair(commentStartIndex, index + 1));
                    commented = false;
                    singleLineCommented = false;
                    commentStartIndex = -1;
                    continue block8;
                }
                case '/': {
                    if (commented || openSingleQuote || openDoubleQuote || index >= length - 1 || sql.charAt(index + 1) != '*') continue block8;
                    commented = true;
                    multiLineCommented = true;
                    commentStartIndex = index++;
                    continue block8;
                }
                case '*': {
                    if (!multiLineCommented || index >= length - 1 || sql.charAt(index + 1) != '/') continue block8;
                    commentedParts.add(new Pairs.IntPair(commentStartIndex, index + 2));
                    commented = false;
                    multiLineCommented = false;
                    commentStartIndex = -1;
                    ++index;
                    continue block8;
                }
            }
        }
        if (commentedParts.isEmpty()) {
            if (singleLineCommented) {
                return sql.substring(0, commentStartIndex);
            }
            return sql;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int startIndex = 0;
        for (Pairs.IntPair commentedPart : commentedParts) {
            stringBuilder.append(sql, startIndex, commentedPart.getLeft()).append(' ');
            startIndex = commentedPart.getRight();
        }
        if (startIndex < length) {
            if (singleLineCommented) {
                stringBuilder.append(sql, startIndex, commentStartIndex);
            } else {
                stringBuilder.append(sql, startIndex, length);
            }
        }
        return stringBuilder.toString();
    }

    private static List<Expression> convertDistinctSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>();
        selectExpr.add(CalciteSqlParser.convertDistinctAndSelectListToFunctionExpression(selectList));
        return selectExpr;
    }

    private static List<Expression> convertSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>();
        for (SqlNode next : selectList) {
            selectExpr.add(CalciteSqlParser.toExpression(next));
        }
        return selectExpr;
    }

    private static List<Expression> convertOrderByList(SqlNodeList orderList) {
        ArrayList<Expression> orderByExpr = new ArrayList<Expression>();
        for (SqlNode next : orderList) {
            orderByExpr.add(CalciteSqlParser.convertOrderBy(next));
        }
        return orderByExpr;
    }

    private static Expression convertOrderBy(SqlNode node) {
        Expression expression;
        if (node.getKind() == SqlKind.DESCENDING) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            expression = RequestUtils.getFunctionExpression("desc");
            expression.getFunctionCall().addToOperands(CalciteSqlParser.toExpression((SqlNode)basicCall.getOperandList().get(0)));
        } else {
            expression = RequestUtils.getFunctionExpression("asc");
            expression.getFunctionCall().addToOperands(CalciteSqlParser.toExpression(node));
        }
        return expression;
    }

    private static Expression convertDistinctAndSelectListToFunctionExpression(SqlNodeList selectList) {
        Expression functionExpression = RequestUtils.getFunctionExpression("distinct");
        for (SqlNode node : selectList) {
            Expression columnExpression = CalciteSqlParser.toExpression(node);
            if (columnExpression.getType() == ExpressionType.IDENTIFIER && columnExpression.getIdentifier().getName().equals("*")) {
                throw new SqlCompilationException("Syntax error: Pinot currently does not support DISTINCT with *. Please specify each column name after DISTINCT keyword");
            }
            if (columnExpression.getType() == ExpressionType.FUNCTION && AggregationFunctionType.isAggregationFunction((String)columnExpression.getFunctionCall().getOperator())) {
                throw new SqlCompilationException("Syntax error: Use of DISTINCT with aggregation functions is not supported");
            }
            functionExpression.getFunctionCall().addToOperands(columnExpression);
        }
        return functionExpression;
    }

    private static Expression toExpression(SqlNode node) {
        LOGGER.debug("Current processing SqlNode: {}, node.getKind(): {}", (Object)node, (Object)node.getKind());
        switch (node.getKind()) {
            case IDENTIFIER: {
                if (((SqlIdentifier)node).isStar()) {
                    return RequestUtils.getIdentifierExpression("*");
                }
                if (((SqlIdentifier)node).isSimple()) {
                    return RequestUtils.getIdentifierExpression(((SqlIdentifier)node).getSimple());
                }
                return RequestUtils.getIdentifierExpression(node.toString());
            }
            case INTERVAL_QUALIFIER: {
                return RequestUtils.getLiteralExpression(node.toString());
            }
            case LITERAL: {
                return RequestUtils.getLiteralExpression((SqlLiteral)node);
            }
            case AS: {
                String aliasName;
                SqlBasicCall asFuncSqlNode = (SqlBasicCall)node;
                List operands = asFuncSqlNode.getOperandList();
                Expression leftExpr = CalciteSqlParser.toExpression((SqlNode)operands.get(0));
                SqlNode aliasSqlNode = (SqlNode)operands.get(1);
                switch (aliasSqlNode.getKind()) {
                    case IDENTIFIER: {
                        aliasName = ((SqlIdentifier)aliasSqlNode).getSimple();
                        break;
                    }
                    case LITERAL: {
                        aliasName = ((SqlLiteral)aliasSqlNode).toValue();
                        break;
                    }
                    default: {
                        throw new SqlCompilationException("Unsupported Alias sql node - " + aliasSqlNode);
                    }
                }
                Expression rightExpr = RequestUtils.getIdentifierExpression(aliasName);
                if (leftExpr.isSetIdentifier() && rightExpr.isSetIdentifier() && leftExpr.getIdentifier().getName().equals(rightExpr.getIdentifier().getName())) {
                    return leftExpr;
                }
                Expression asFuncExpr = RequestUtils.getFunctionExpression("as");
                asFuncExpr.getFunctionCall().addToOperands(leftExpr);
                asFuncExpr.getFunctionCall().addToOperands(rightExpr);
                return asFuncExpr;
            }
            case CASE: {
                SqlCase caseSqlNode = (SqlCase)node;
                SqlNodeList whenOperands = caseSqlNode.getWhenOperands();
                SqlNodeList thenOperands = caseSqlNode.getThenOperands();
                SqlNode elseOperand = caseSqlNode.getElseOperand();
                Expression caseFuncExpr = RequestUtils.getFunctionExpression("case");
                Preconditions.checkState((whenOperands.size() == thenOperands.size() ? 1 : 0) != 0);
                for (SqlNode whenSqlNode : whenOperands.getList()) {
                    Expression whenExpression = CalciteSqlParser.toExpression(whenSqlNode);
                    if (CalciteSqlParser.isAggregateExpression(whenExpression)) {
                        throw new SqlCompilationException("Aggregation functions inside WHEN Clause is not supported - " + whenSqlNode);
                    }
                    caseFuncExpr.getFunctionCall().addToOperands(whenExpression);
                }
                for (SqlNode thenSqlNode : thenOperands.getList()) {
                    Expression thenExpression = CalciteSqlParser.toExpression(thenSqlNode);
                    if (CalciteSqlParser.isAggregateExpression(thenExpression)) {
                        throw new SqlCompilationException("Aggregation functions inside THEN Clause is not supported - " + thenSqlNode);
                    }
                    caseFuncExpr.getFunctionCall().addToOperands(thenExpression);
                }
                Expression elseExpression = CalciteSqlParser.toExpression(elseOperand);
                if (CalciteSqlParser.isAggregateExpression(elseExpression)) {
                    throw new SqlCompilationException("Aggregation functions inside ELSE Clause is not supported - " + elseExpression);
                }
                caseFuncExpr.getFunctionCall().addToOperands(elseExpression);
                return caseFuncExpr;
            }
        }
        if (node instanceof SqlDataTypeSpec) {
            return RequestUtils.getLiteralExpression(((SqlDataTypeSpec)node).getTypeName().getSimple());
        }
        return CalciteSqlParser.compileFunctionExpression((SqlBasicCall)node);
    }

    private static Expression compileFunctionExpression(SqlBasicCall functionNode) {
        String canonicalName;
        SqlKind functionKind = functionNode.getKind();
        boolean negated = false;
        switch (functionKind) {
            case AND: {
                return CalciteSqlParser.compileAndExpression(functionNode);
            }
            case OR: {
                return CalciteSqlParser.compileOrExpression(functionNode);
            }
            case BETWEEN: {
                negated = ((SqlBetweenOperator)functionNode.getOperator()).isNegated();
                canonicalName = SqlKind.BETWEEN.name();
                break;
            }
            case LIKE: {
                negated = ((SqlLikeOperator)functionNode.getOperator()).isNegated();
                canonicalName = SqlKind.LIKE.name();
                break;
            }
            case OTHER: 
            case OTHER_FUNCTION: 
            case DOT: {
                String functionName = functionNode.getOperator().getName();
                if (functionName.equals("ITEM") || functionName.equals("DOT")) {
                    StringBuilder pathBuilder = new StringBuilder();
                    CalciteSqlParser.compilePathExpression(functionNode, pathBuilder);
                    return RequestUtils.getIdentifierExpression(pathBuilder.toString());
                }
                canonicalName = RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(functionName);
                if (functionNode.getFunctionQuantifier() == null || !"DISTINCT".equals(functionNode.getFunctionQuantifier().toString())) break;
                if (canonicalName.equals("count")) {
                    canonicalName = "distinctcount";
                    break;
                }
                if (!AggregationFunctionType.isAggregationFunction((String)canonicalName)) break;
                throw new SqlCompilationException("Function '" + functionName + "' on DISTINCT is not supported.");
            }
            default: {
                canonicalName = RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(functionKind.name());
            }
        }
        List childNodes = functionNode.getOperandList();
        ArrayList<Expression> operands = new ArrayList<Expression>(childNodes.size());
        for (SqlNode childNode : childNodes) {
            if (childNode instanceof SqlNodeList) {
                for (SqlNode node : (SqlNodeList)childNode) {
                    operands.add(CalciteSqlParser.toExpression(node));
                }
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        CalciteSqlParser.validateFunction(canonicalName, operands);
        Expression functionExpression = RequestUtils.getFunctionExpression(canonicalName);
        functionExpression.getFunctionCall().setOperands(operands);
        if (negated) {
            Expression negatedFunctionExpression = RequestUtils.getFunctionExpression(FilterKind.NOT.name());
            ArrayList<Expression> negatedFunctionOperands = new ArrayList<Expression>(1);
            negatedFunctionOperands.add(functionExpression);
            negatedFunctionExpression.getFunctionCall().setOperands(negatedFunctionOperands);
            return negatedFunctionExpression;
        }
        return functionExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void compilePathExpression(SqlBasicCall functionNode, StringBuilder pathBuilder) {
        List operands = functionNode.getOperandList();
        SqlNode operand0 = (SqlNode)operands.get(0);
        SqlKind kind0 = operand0.getKind();
        if (kind0 == SqlKind.IDENTIFIER) {
            pathBuilder.append(operand0);
        } else {
            if (kind0 != SqlKind.DOT && kind0 != SqlKind.OTHER_FUNCTION) throw new SqlCompilationException("SELECT list item has bad path expression.");
            SqlBasicCall function0 = (SqlBasicCall)operand0;
            String name0 = function0.getOperator().getName();
            if (!name0.equals("ITEM") && !name0.equals("DOT")) throw new SqlCompilationException("SELECT list item has bad path expression.");
            CalciteSqlParser.compilePathExpression(function0, pathBuilder);
        }
        SqlNode operand1 = (SqlNode)operands.get(1);
        SqlKind kind1 = operand1.getKind();
        if (kind1 == SqlKind.IDENTIFIER) {
            pathBuilder.append('.').append(((SqlIdentifier)operand1).getSimple());
            return;
        } else {
            if (kind1 != SqlKind.LITERAL) throw new SqlCompilationException("SELECT list item has bad path expression.");
            pathBuilder.append('[').append(((SqlLiteral)operand1).toValue()).append(']');
        }
    }

    private static void validateFunction(String canonicalName, List<Expression> operands) {
        switch (canonicalName) {
            case "jsonextractscalar": {
                CalciteSqlParser.validateJsonExtractScalarFunction(operands);
                break;
            }
            case "jsonextractkey": {
                CalciteSqlParser.validateJsonExtractKeyFunction(operands);
                break;
            }
        }
    }

    private static void validateJsonExtractScalarFunction(List<Expression> operands) {
        int numOperands = operands.size();
        if (numOperands != 3 && numOperands != 4) {
            throw new SqlCompilationException("Expect 3 or 4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        if (!operands.get(1).isSetLiteral() || !operands.get(2).isSetLiteral() || numOperands == 4 && !operands.get(3).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd/3rd/4th argument of transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue']) to be a single-quoted literal value.");
        }
    }

    private static void validateJsonExtractKeyFunction(List<Expression> operands) {
        if (operands.size() != 2) {
            throw new SqlCompilationException("Expect 2 arguments are required for transform function: jsonExtractKey(jsonFieldName, 'jsonPath')");
        }
        if (!operands.get(1).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd argument for transform function: jsonExtractKey(jsonFieldName, 'jsonPath') to be a single-quoted literal value.");
        }
    }

    private static Expression compileAndExpression(SqlBasicCall andNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : andNode.getOperandList()) {
            if (childNode.getKind() == SqlKind.AND) {
                Expression childAndExpression = CalciteSqlParser.compileAndExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        Expression andExpression = RequestUtils.getFunctionExpression(FilterKind.AND.name());
        andExpression.getFunctionCall().setOperands(operands);
        return andExpression;
    }

    private static Expression compileOrExpression(SqlBasicCall orNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : orNode.getOperandList()) {
            if (childNode.getKind() == SqlKind.OR) {
                Expression childAndExpression = CalciteSqlParser.compileOrExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        Expression andExpression = RequestUtils.getFunctionExpression(FilterKind.OR.name());
        andExpression.getFunctionCall().setOperands(operands);
        return andExpression;
    }

    public static boolean isLiteralOnlyExpression(Expression e) {
        if (e.getType() == ExpressionType.LITERAL) {
            return true;
        }
        if (e.getType() == ExpressionType.FUNCTION) {
            Function function = e.getFunctionCall();
            if (function.getOperator().equals("as")) {
                return CalciteSqlParser.isLiteralOnlyExpression(function.getOperands().get(0));
            }
            return false;
        }
        return false;
    }
}

