/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.IsNotNullPredicate;
import org.apache.pinot.common.request.context.predicate.IsNullPredicate;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextContainsPredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.common.utils.RegexpPatternConverterUtils;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class RequestContextUtils {
    private RequestContextUtils() {
    }

    public static ExpressionContext getExpression(String expression) {
        if (expression.equals("*")) {
            return ExpressionContext.forIdentifier("*");
        }
        return RequestContextUtils.getExpression(CalciteSqlParser.compileToExpression(expression));
    }

    public static ExpressionContext getExpression(Expression thriftExpression) {
        switch (thriftExpression.getType()) {
            case LITERAL: {
                return ExpressionContext.forLiteralContext(thriftExpression.getLiteral());
            }
            case IDENTIFIER: {
                return ExpressionContext.forIdentifier(thriftExpression.getIdentifier().getName());
            }
            case FUNCTION: {
                return ExpressionContext.forFunction(RequestContextUtils.getFunction(thriftExpression.getFunctionCall()));
            }
        }
        throw new IllegalStateException();
    }

    public static FunctionContext getFunction(Function thriftFunction) {
        String functionName = thriftFunction.getOperator();
        FunctionContext.Type functionType = AggregationFunctionType.isAggregationFunction((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List<Expression> operands = thriftFunction.getOperands();
        if (operands != null) {
            ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(operands.size());
            for (Expression operand : operands) {
                arguments.add(RequestContextUtils.getExpression(operand));
            }
            if (arguments.isEmpty() && functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
                arguments.add(ExpressionContext.forIdentifier("*"));
            }
            return new FunctionContext(functionType, functionName, arguments);
        }
        return new FunctionContext(functionType, functionName, Collections.emptyList());
    }

    public static FilterContext getFilter(Expression thriftExpression) {
        ExpressionType type = thriftExpression.getType();
        switch (type) {
            case FUNCTION: {
                Function thriftFunction = thriftExpression.getFunctionCall();
                return RequestContextUtils.getFilter(thriftFunction);
            }
            case IDENTIFIER: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(RequestContextUtils.getExpression(thriftExpression), RequestContextUtils.getStringValue(RequestUtils.getLiteralExpression(true))));
            }
            case LITERAL: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public static FilterContext getFilter(Function thriftFunction) {
        String functionOperator = thriftFunction.getOperator();
        if (!EnumUtils.isValidEnum(FilterKind.class, (String)functionOperator)) {
            return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(ExpressionContext.forFunction(RequestContextUtils.getFunction(thriftFunction)), RequestContextUtils.getStringValue(RequestUtils.getLiteralExpression(true))));
        }
        FilterKind filterKind = FilterKind.valueOf(thriftFunction.getOperator().toUpperCase());
        List<Expression> operands = thriftFunction.getOperands();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case NOT: {
                assert (numOperands == 1);
                return new FilterContext(FilterContext.Type.NOT, new ArrayList<FilterContext>(Collections.singletonList(RequestContextUtils.getFilter(operands.get(0)))), null);
            }
            case EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case GREATER_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case GREATER_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case LESS_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", false, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LESS_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", true, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case BETWEEN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2))));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_CONTAINS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextContainsPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new JsonMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(Expression thriftExpression) {
        if (thriftExpression.getType() != ExpressionType.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return thriftExpression.getLiteral().getFieldValue().toString();
    }

    public static FilterContext getFilter(ExpressionContext filterExpression) {
        ExpressionContext.Type type = filterExpression.getType();
        switch (type) {
            case FUNCTION: {
                FunctionContext filterFunction = filterExpression.getFunction();
                return RequestContextUtils.getFilter(filterFunction);
            }
            case IDENTIFIER: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(filterExpression, RequestContextUtils.getStringValue(RequestUtils.getLiteralExpression(true))));
            }
            case LITERAL: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public static FilterContext getFilter(FunctionContext filterFunction) {
        String functionOperator = filterFunction.getFunctionName().toUpperCase();
        if (!EnumUtils.isValidEnum(FilterKind.class, (String)functionOperator)) {
            return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(ExpressionContext.forFunction(filterFunction), RequestContextUtils.getStringValue(RequestUtils.getLiteralExpression(true))));
        }
        FilterKind filterKind = FilterKind.valueOf(filterFunction.getFunctionName().toUpperCase());
        List<ExpressionContext> operands = filterFunction.getArguments();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    children.add(RequestContextUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case NOT: {
                assert (numOperands == 1);
                return new FilterContext(FilterContext.Type.NOT, new ArrayList<FilterContext>(Collections.singletonList(RequestContextUtils.getFilter(operands.get(0)))), null);
            }
            case EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(operands.get(0), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(operands.get(0), values));
            }
            case GREATER_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case GREATER_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*"));
            }
            case LESS_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, "*", false, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LESS_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), false, "*", true, RequestContextUtils.getStringValue(operands.get(1))));
            }
            case BETWEEN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2))));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(operands.get(0), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_CONTAINS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextContainsPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new JsonMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(operands.get(0)));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(operands.get(0)));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return expressionContext.getLiteralString();
    }
}

