/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.spi.data.FieldSpec;

public class LiteralContext {
    private FieldSpec.DataType _type;
    private Object _value;

    private static FieldSpec.DataType convertThriftTypeToDataType(Literal._Fields fields) {
        switch (fields) {
            case LONG_VALUE: {
                return FieldSpec.DataType.LONG;
            }
            case BOOL_VALUE: {
                return FieldSpec.DataType.BOOLEAN;
            }
            case DOUBLE_VALUE: {
                return FieldSpec.DataType.DOUBLE;
            }
            case STRING_VALUE: {
                return FieldSpec.DataType.STRING;
            }
        }
        throw new UnsupportedOperationException("Unsupported literal type:" + fields);
    }

    private static Class<?> convertDataTypeToJavaType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new UnsupportedOperationException("Unsupported dataType:" + dataType);
    }

    public LiteralContext(Literal literal) {
        this._type = LiteralContext.convertThriftTypeToDataType((Literal._Fields)literal.getSetField());
        this._value = literal.getFieldValue();
    }

    public FieldSpec.DataType getType() {
        return this._type;
    }

    @Nullable
    public Object getValue() {
        return this._value;
    }

    public LiteralContext(FieldSpec.DataType type, Object value) {
        Preconditions.checkArgument((LiteralContext.convertDataTypeToJavaType(type) == value.getClass() ? 1 : 0) != 0, (Object)("Unmatched data type: " + type + " java type: " + value.getClass()));
        this._type = type;
        this._value = value;
    }

    public int hashCode() {
        if (this._value == null) {
            return 31 * this._type.hashCode();
        }
        return 31 * this._value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralContext)) {
            return false;
        }
        LiteralContext that = (LiteralContext)o;
        return this._type.equals((Object)that._type) && Objects.equals(this._value, that._value);
    }

    public String toString() {
        if (this._value == null) {
            return "null";
        }
        return "'" + this._value.toString() + "'";
    }
}

