/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util.trace;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pinot.core.util.trace.TracedThread;

public final class TracedThreadFactory
implements ThreadFactory {
    private final int _priority;
    private final boolean _daemon;
    private final String _nameFormat;
    private final AtomicInteger _count = new AtomicInteger();

    public TracedThreadFactory(int priority, boolean daemon, String nameFormat) {
        this._priority = priority;
        this._daemon = daemon;
        this._nameFormat = nameFormat;
    }

    @Override
    public Thread newThread(Runnable task) {
        TracedThread thread = new TracedThread(task);
        thread.setPriority(this._priority);
        thread.setDaemon(this._daemon);
        thread.setName(String.format(this._nameFormat, this._count.getAndIncrement()));
        return thread;
    }
}

