/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.datatable.DataTable;

@ThreadSafe
public class ServerResponse {
    private final long _startTimeMs;
    private volatile long _submitRequestTimeMs;
    private volatile int _requestSentLatencyMs = -1;
    private volatile long _receiveDataTableTimeMs;
    private volatile DataTable _dataTable;
    private volatile int _responseSize;
    private volatile int _deserializationTimeMs;

    public ServerResponse(long startTimeMs) {
        this._startTimeMs = startTimeMs;
    }

    @Nullable
    public DataTable getDataTable() {
        return this._dataTable;
    }

    public int getSubmitDelayMs() {
        if (this._submitRequestTimeMs != 0L) {
            return (int)(this._submitRequestTimeMs - this._startTimeMs);
        }
        return -1;
    }

    public int getRequestSentDelayMs() {
        return this._requestSentLatencyMs;
    }

    public int getResponseDelayMs() {
        if (this._receiveDataTableTimeMs == 0L) {
            return -1;
        }
        if (this._receiveDataTableTimeMs < this._submitRequestTimeMs) {
            return 0;
        }
        return (int)(this._receiveDataTableTimeMs - this._submitRequestTimeMs);
    }

    public int getResponseSize() {
        return this._responseSize;
    }

    public int getDeserializationTimeMs() {
        return this._deserializationTimeMs;
    }

    public String toString() {
        return String.format("%d,%d,%d,%d,%d", this.getSubmitDelayMs(), this.getResponseDelayMs(), this.getResponseSize(), this.getDeserializationTimeMs(), this.getRequestSentDelayMs());
    }

    void markRequestSubmitted() {
        this._submitRequestTimeMs = System.currentTimeMillis();
    }

    void markRequestSent(int requestSentLatencyMs) {
        this._requestSentLatencyMs = requestSentLatencyMs;
    }

    void receiveDataTable(DataTable dataTable, int responseSize, int deserializationTimeMs) {
        this._receiveDataTableTimeMs = System.currentTimeMillis();
        this._dataTable = dataTable;
        this._responseSize = responseSize;
        this._deserializationTimeMs = deserializationTimeMs;
    }
}

