/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.utils.ByteArray;

public class OrderByComparatorFactory {
    private OrderByComparatorFactory() {
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, TransformResultMetadata[] orderByExpressionMetadata, boolean reverse, boolean nullHandlingEnabled) {
        return OrderByComparatorFactory.getComparator(orderByExpressions, orderByExpressionMetadata, reverse, nullHandlingEnabled, 0, orderByExpressions.size());
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, TransformResultMetadata[] orderByExpressionMetadata, boolean reverse, boolean nullHandlingEnabled, int from, int to) {
        Preconditions.checkArgument((to <= orderByExpressions.size() ? 1 : 0) != 0, (String)"Trying to access %sth position of orderByExpressions with size %s", (int)to, (int)orderByExpressions.size());
        Preconditions.checkArgument((to <= orderByExpressionMetadata.length ? 1 : 0) != 0, (String)"Trying to access %sth position of orderByExpressionMetadata with size %s", (int)to, (int)orderByExpressionMetadata.length);
        Preconditions.checkArgument((from < to ? 1 : 0) != 0, (String)"FROM (%s) must be lower than TO (%s)", (int)from, (int)to);
        int numOrderByExpressions = to - from;
        ArrayList<Integer> valueIndexList = new ArrayList<Integer>(numOrderByExpressions);
        for (int i = from; i < to; ++i) {
            if (!orderByExpressionMetadata[i].isSingleValue()) {
                throw new BadQueryRequestException(String.format("MV expression: %s should not be included in the ORDER-BY clause", orderByExpressions.get(i)));
            }
            valueIndexList.add(i);
        }
        int numValuesToCompare = valueIndexList.size();
        int[] valueIndices = new int[numValuesToCompare];
        FieldSpec.DataType[] storedTypes = new FieldSpec.DataType[numValuesToCompare];
        int[] multipliers = new int[numValuesToCompare];
        int ascMult = reverse ? -1 : 1;
        int descMult = reverse ? 1 : -1;
        for (int i = 0; i < numValuesToCompare; ++i) {
            int valueIndex;
            valueIndices[i] = valueIndex = ((Integer)valueIndexList.get(i)).intValue();
            storedTypes[i] = orderByExpressionMetadata[valueIndex].getDataType().getStoredType();
            multipliers[i] = orderByExpressions.get(valueIndex).isAsc() ? ascMult : descMult;
        }
        if (nullHandlingEnabled) {
            return (o1, o2) -> {
                for (int i = 0; i < numValuesToCompare; ++i) {
                    int index = valueIndices[i];
                    Object v1 = o1[index];
                    Object v2 = o2[index];
                    if (v1 == null) {
                        return v2 == null ? 0 : -multipliers[i];
                    }
                    if (v2 == null) {
                        return multipliers[i];
                    }
                    int result = OrderByComparatorFactory.compareCols(v1, v2, storedTypes[i], multipliers[i]);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            };
        }
        return (o1, o2) -> {
            for (int i = 0; i < numValuesToCompare; ++i) {
                int index = valueIndices[i];
                int result = OrderByComparatorFactory.compareCols(o1[index], o2[index], storedTypes[i], multipliers[i]);
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    private static int compareCols(Object v1, Object v2, FieldSpec.DataType type, int multiplier) {
        int result;
        switch (type) {
            case INT: {
                result = ((Integer)v1).compareTo((Integer)v2);
                break;
            }
            case LONG: {
                result = ((Long)v1).compareTo((Long)v2);
                break;
            }
            case FLOAT: {
                result = ((Float)v1).compareTo((Float)v2);
                break;
            }
            case DOUBLE: {
                result = ((Double)v1).compareTo((Double)v2);
                break;
            }
            case BIG_DECIMAL: {
                result = ((BigDecimal)v1).compareTo((BigDecimal)v2);
                break;
            }
            case STRING: {
                result = ((String)v1).compareTo((String)v2);
                break;
            }
            case BYTES: {
                result = ((ByteArray)v1).compareTo((ByteArray)v2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result * multiplier;
    }
}

