/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.spi.utils.LoopUtils;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOperatorService {
    private final QueryContext _queryContext;
    private final List<String> _selectionColumns;
    private final DataSchema _dataSchema;
    private final int _offset;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;

    public SelectionOperatorService(QueryContext queryContext, DataSchema dataSchema) {
        this._queryContext = queryContext;
        this._selectionColumns = SelectionOperatorUtils.getSelectionColumns(queryContext, dataSchema);
        this._dataSchema = dataSchema;
        this._offset = queryContext.getOffset();
        this._numRowsToKeep = this._offset + queryContext.getLimit();
        assert (queryContext.getOrderByExpressions() != null);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), SelectionOperatorUtils.getTypeCompatibleComparator(queryContext.getOrderByExpressions(), this._dataSchema, this._queryContext.isNullHandlingEnabled()));
    }

    public PriorityQueue<Object[]> getRows() {
        return this._rows;
    }

    public void reduceWithOrdering(Collection<DataTable> dataTables, boolean nullHandlingEnabled) {
        for (DataTable dataTable : dataTables) {
            int numRows = dataTable.getNumberOfRows();
            if (nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[dataTable.getDataSchema().size()];
                for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                    nullBitmaps[colId] = dataTable.getNullRowIds(colId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    LoopUtils.checkMergePhaseInterruption((int)rowId);
                    Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                    for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows; ++rowId) {
                LoopUtils.checkMergePhaseInterruption((int)rowId);
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
            }
        }
    }

    public ResultTable renderResultTableWithOrdering() {
        int[] columnIndices = SelectionOperatorUtils.getColumnIndices(this._selectionColumns, this._dataSchema);
        int numColumns = columnIndices.length;
        DataSchema resultDataSchema = SelectionOperatorUtils.getSchemaForProjection(this._dataSchema, columnIndices);
        LinkedList<Object[]> rowsInSelectionResults = new LinkedList<Object[]>();
        while (this._rows.size() > this._offset) {
            Object[] row = this._rows.poll();
            assert (row != null);
            Object[] extractedRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = row[columnIndices[i]];
                if (value == null) continue;
                extractedRow[i] = resultDataSchema.getColumnDataType(i).convertAndFormat(value);
            }
            rowsInSelectionResults.addFirst(extractedRow);
        }
        return new ResultTable(resultDataSchema, rowsInSelectionResults);
    }
}

