/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.tokenbucket;

import java.util.concurrent.atomic.LongAccumulator;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.scheduler.MultiLevelPriorityQueue;
import org.apache.pinot.core.query.scheduler.PriorityScheduler;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.core.query.scheduler.TableBasedGroupMapper;
import org.apache.pinot.core.query.scheduler.resources.PolicyBasedResourceManager;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.core.query.scheduler.tokenbucket.TokenSchedulerGroup;
import org.apache.pinot.spi.env.PinotConfiguration;

public class TokenPriorityScheduler
extends PriorityScheduler {
    public static final String TOKENS_PER_MS_KEY = "tokens_per_ms";
    public static final String TOKEN_LIFETIME_MS_KEY = "token_lifetime_ms";
    private static final int DEFAULT_TOKEN_LIFETIME_MS = 100;

    public static TokenPriorityScheduler create(PinotConfiguration config, QueryExecutor queryExecutor, ServerMetrics metrics, LongAccumulator latestQueryTime) {
        final PolicyBasedResourceManager rm = new PolicyBasedResourceManager(config);
        SchedulerGroupFactory groupFactory = new SchedulerGroupFactory(){

            @Override
            public SchedulerGroup create(PinotConfiguration config, String groupName) {
                int maxTokensPerMs = rm.getNumQueryRunnerThreads() + rm.getNumQueryWorkerThreads();
                int tokensPerMs = config.getProperty(TokenPriorityScheduler.TOKENS_PER_MS_KEY, maxTokensPerMs);
                int tokenLifetimeMs = config.getProperty(TokenPriorityScheduler.TOKEN_LIFETIME_MS_KEY, 100);
                return new TokenSchedulerGroup(groupName, tokensPerMs, tokenLifetimeMs);
            }
        };
        MultiLevelPriorityQueue queue = new MultiLevelPriorityQueue(config, rm, groupFactory, new TableBasedGroupMapper());
        return new TokenPriorityScheduler(config, (ResourceManager)rm, queryExecutor, queue, metrics, latestQueryTime);
    }

    private TokenPriorityScheduler(PinotConfiguration config, ResourceManager resourceManager, QueryExecutor queryExecutor, MultiLevelPriorityQueue queue, ServerMetrics metrics, LongAccumulator latestQueryTime) {
        super(config, resourceManager, queryExecutor, queue, metrics, latestQueryTime);
    }

    @Override
    public String name() {
        return "TokenBucket";
    }
}

