/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class FlattenAndOrFilterOptimizer
implements FilterOptimizer {
    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        return this.optimize(filterExpression);
    }

    private Expression optimize(Expression filterExpression) {
        Function function = filterExpression.getFunctionCall();
        String operator = function.getOperator();
        if (!operator.equals(FilterKind.AND.name()) && !operator.equals(FilterKind.OR.name())) {
            return filterExpression;
        }
        List children = function.getOperands();
        assert (children != null);
        ArrayList<Expression> newChildren = new ArrayList<Expression>();
        for (Expression child : children) {
            Expression optimizedChild = this.optimize(child);
            Function childFunction = optimizedChild.getFunctionCall();
            if (childFunction.getOperator().equals(operator)) {
                newChildren.addAll(childFunction.getOperands());
                continue;
            }
            newChildren.add(optimizedChild);
        }
        function.setOperands(newChildren);
        return filterExpression;
    }
}

