/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawBytesSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class RawBytesSingleColumnDistinctOnlyExecutor
extends BaseRawBytesSingleColumnDistinctExecutor {
    public RawBytesSingleColumnDistinctOnlyExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        byte[][] values = blockValueSet.getBytesValuesSV();
        int numDocs = transformBlock.getNumDocs();
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
            for (int i = 0; i < numDocs; ++i) {
                if (nullBitmap != null && nullBitmap.contains(i)) {
                    values[i] = null;
                }
                this._valueSet.add((Object)new ByteArray(values[i]));
                if (this._valueSet.size() < this._limit) continue;
                return true;
            }
        } else {
            for (int i = 0; i < numDocs; ++i) {
                this._valueSet.add((Object)new ByteArray(values[i]));
                if (this._valueSet.size() < this._limit) continue;
                return true;
            }
        }
        return false;
    }
}

