/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.transform.PassThroughTransformOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectionPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class TransformPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final Collection<ExpressionContext> _expressions;
    private final int _maxDocsPerCall;
    private final BaseFilterOperator _filterOperator;

    public TransformPlanNode(IndexSegment indexSegment, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall) {
        this(indexSegment, queryContext, expressions, maxDocsPerCall, null);
    }

    public TransformPlanNode(IndexSegment indexSegment, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall, @Nullable BaseFilterOperator filterOperator) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._expressions = expressions;
        this._maxDocsPerCall = maxDocsPerCall;
        this._filterOperator = filterOperator;
    }

    public TransformOperator run() {
        HashSet<String> projectionColumns = new HashSet<String>();
        boolean hasNonIdentifierExpression = false;
        for (ExpressionContext expression : this._expressions) {
            expression.getColumns(projectionColumns);
            if (expression.getType() == ExpressionContext.Type.IDENTIFIER) continue;
            hasNonIdentifierExpression = true;
        }
        ProjectionOperator projectionOperator = new ProjectionPlanNode(this._indexSegment, this._queryContext, projectionColumns, this._maxDocsPerCall, this._filterOperator).run();
        if (hasNonIdentifierExpression) {
            return new TransformOperator(this._queryContext, projectionOperator, this._expressions);
        }
        return new PassThroughTransformOperator(projectionOperator, this._expressions);
    }
}

