/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class ScalarTransformFunctionWrapper
extends BaseTransformFunction {
    private final String _name;
    private final FunctionInvoker _functionInvoker;
    private final PinotDataType _resultType;
    private final TransformResultMetadata _resultMetadata;
    private Object[] _arguments;
    private int _numNonLiteralArguments;
    private int[] _nonLiteralIndices;
    private TransformFunction[] _nonLiteralFunctions;
    private Object[][] _nonLiteralValues;

    public ScalarTransformFunctionWrapper(FunctionInfo functionInfo) {
        this._name = functionInfo.getMethod().getName();
        this._functionInvoker = new FunctionInvoker(functionInfo);
        Class[] parameterClasses = this._functionInvoker.getParameterClasses();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        int numParameters = parameterClasses.length;
        for (int i = 0; i < numParameters; ++i) {
            Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
        }
        Class resultClass = this._functionInvoker.getResultClass();
        PinotDataType resultType = FunctionUtils.getParameterType((Class)resultClass);
        if (resultType != null) {
            this._resultType = resultType;
            this._resultMetadata = new TransformResultMetadata(FunctionUtils.getDataType((Class)resultClass), this._resultType.isSingleValue(), false);
        } else {
            this._resultType = PinotDataType.STRING;
            this._resultMetadata = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        PinotDataType[] parameterTypes;
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == (parameterTypes = this._functionInvoker.getParameterTypes()).length ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)this._functionInvoker.getMethod(), (Object)parameterTypes.length, (Object)numArguments);
        this._arguments = new Object[numArguments];
        this._nonLiteralIndices = new int[numArguments];
        this._nonLiteralFunctions = new TransformFunction[numArguments];
        for (int i = 0; i < numArguments; ++i) {
            TransformFunction transformFunction = arguments.get(i);
            if (transformFunction instanceof LiteralTransformFunction) {
                String literal = ((LiteralTransformFunction)transformFunction).getLiteral();
                this._arguments[i] = parameterTypes[i].convert((Object)literal, PinotDataType.STRING);
                continue;
            }
            this._nonLiteralIndices[this._numNonLiteralArguments] = i;
            this._nonLiteralFunctions[this._numNonLiteralArguments] = transformFunction;
            ++this._numNonLiteralArguments;
        }
        this._nonLiteralValues = new Object[this._numNonLiteralArguments][];
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intValuesSV[i] = (Integer)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longValuesSV[i] = (Long)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatValuesSV[i] = ((Float)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments))).floatValue();
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleValuesSV[i] = (Double)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BIG_DECIMAL) {
            return super.transformToBigDecimalValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._bigDecimalValuesSV[i] = (BigDecimal)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[length];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object result = this._functionInvoker.invoke(this._arguments);
            this._stringValuesSV[i] = this._resultType == PinotDataType.STRING ? result.toString() : (String)this._resultType.toInternal(result);
        }
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._bytesValuesSV == null) {
            this._bytesValuesSV = new byte[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._bytesValuesSV[i] = (byte[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._bytesValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intValuesMV[i] = (int[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longValuesMV[i] = (long[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatValuesMV[i] = (float[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleValuesMV[i] = (double[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[length][];
        }
        this.getNonLiteralValues(projectionBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._stringValuesMV[i] = (String[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._stringValuesMV;
    }

    private void getNonLiteralValues(ProjectionBlock projectionBlock) {
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        block16: for (int i = 0; i < this._numNonLiteralArguments; ++i) {
            PinotDataType parameterType = parameterTypes[this._nonLiteralIndices[i]];
            TransformFunction transformFunction = this._nonLiteralFunctions[i];
            switch (parameterType) {
                case INTEGER: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((int[])transformFunction.transformToIntValuesSV(projectionBlock));
                    continue block16;
                }
                case LONG: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((long[])transformFunction.transformToLongValuesSV(projectionBlock));
                    continue block16;
                }
                case FLOAT: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((float[])transformFunction.transformToFloatValuesSV(projectionBlock));
                    continue block16;
                }
                case DOUBLE: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((double[])transformFunction.transformToDoubleValuesSV(projectionBlock));
                    continue block16;
                }
                case BIG_DECIMAL: {
                    this._nonLiteralValues[i] = transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                    continue block16;
                }
                case BOOLEAN: {
                    int j;
                    int[] intValues = transformFunction.transformToIntValuesSV(projectionBlock);
                    int numValues = intValues.length;
                    Boolean[] booleanValues = new Boolean[numValues];
                    for (j = 0; j < numValues; ++j) {
                        booleanValues[j] = intValues[j] == 1;
                    }
                    this._nonLiteralValues[i] = booleanValues;
                    continue block16;
                }
                case TIMESTAMP: {
                    int j;
                    long[] longValues = transformFunction.transformToLongValuesSV(projectionBlock);
                    int numValues = longValues.length;
                    Timestamp[] timestampValues = new Timestamp[numValues];
                    for (j = 0; j < numValues; ++j) {
                        timestampValues[j] = new Timestamp(longValues[j]);
                    }
                    this._nonLiteralValues[i] = timestampValues;
                    continue block16;
                }
                case STRING: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesSV(projectionBlock);
                    continue block16;
                }
                case BYTES: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToBytesValuesSV(projectionBlock);
                    continue block16;
                }
                case PRIMITIVE_INT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToIntValuesMV(projectionBlock);
                    continue block16;
                }
                case PRIMITIVE_LONG_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToLongValuesMV(projectionBlock);
                    continue block16;
                }
                case PRIMITIVE_FLOAT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToFloatValuesMV(projectionBlock);
                    continue block16;
                }
                case PRIMITIVE_DOUBLE_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToDoubleValuesMV(projectionBlock);
                    continue block16;
                }
                case STRING_ARRAY: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesMV(projectionBlock);
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unsupported parameter type: " + parameterType);
                }
            }
        }
    }
}

