/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.PushDownTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.evaluator.TransformEvaluator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class IdentifierTransformFunction
implements TransformFunction,
PushDownTransformFunction {
    private final String _columnName;
    private final Dictionary _dictionary;
    private final TransformResultMetadata _resultMetadata;

    public IdentifierTransformFunction(String columnName, DataSource dataSource) {
        this._columnName = columnName;
        this._dictionary = dataSource.getDictionary();
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        this._resultMetadata = new TransformResultMetadata(dataSourceMetadata.getDataType(), dataSourceMetadata.isSingleValue(), this._dictionary != null);
    }

    public String getColumnName() {
        return this._columnName;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDictionaryIdsSV();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDictionaryIdsMV();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getIntValuesSV();
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getLongValuesSV();
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getFloatValuesSV();
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDoubleValuesSV();
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getBigDecimalValuesSV();
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getStringValuesSV();
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getBytesValuesSV();
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getIntValuesMV();
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getLongValuesMV();
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getFloatValuesMV();
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDoubleValuesMV();
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getStringValuesMV();
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getBytesValuesMV();
    }

    @Override
    public void transformToIntValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, int[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToLongValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, long[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToFloatValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, float[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToDoubleValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, double[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToBigDecimalValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, BigDecimal[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToStringValuesSV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, String[] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToIntValuesMV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, int[][] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToLongValuesMV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, long[][] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToFloatValuesMV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, float[][] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToDoubleValuesMV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, double[][] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }

    @Override
    public void transformToStringValuesMV(ProjectionBlock projectionBlock, TransformEvaluator evaluator, String[][] buffer) {
        projectionBlock.fillValues(this._columnName, evaluator, buffer);
    }
}

