/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.query.LinearSelectionOrderByOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class SelectionPartiallyOrderedByDescOperation
extends LinearSelectionOrderByOperator {
    private static final String EXPLAIN_NAME = "SELECT_PARTIAL_ORDER_BY_DESC";
    private int _numDocsScanned = 0;

    public SelectionPartiallyOrderedByDescOperation(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator, int numSortedExpressions) {
        super(indexSegment, queryContext, expressions, transformOperator, numSortedExpressions);
        assert (queryContext.getOrderByExpressions() != null);
        Preconditions.checkArgument((boolean)queryContext.getOrderByExpressions().stream().filter(expr -> expr.getExpression().getType() == ExpressionContext.Type.IDENTIFIER).findFirst().orElseThrow(() -> new IllegalArgumentException("The query is not order by identifiers")).isDesc(), (String)"%s can only be used when the first column in order by is DESC", (Object)EXPLAIN_NAME);
    }

    @Override
    protected List<Object[]> fetch(Supplier<LinearSelectionOrderByOperator.ListBuilder> listBuilderSupplier) {
        TransformBlock transformBlock;
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        List<Object[]> localBestRows = new ArrayList<Object[]>();
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            IntFunction<Object[]> rowFetcher = this.fetchBlock(transformBlock, blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            this._numDocsScanned += numDocsFetched;
            LinearSelectionOrderByOperator.ListBuilder listBuilder = listBuilderSupplier.get();
            boolean enoughRowsCollected = false;
            for (int docId = numDocsFetched - 1; docId >= 0 && !(enoughRowsCollected = listBuilder.add(rowFetcher.apply(docId))); --docId) {
            }
            if (!enoughRowsCollected) {
                Iterator localBestRowIt = localBestRows.iterator();
                while (!enoughRowsCollected && localBestRowIt.hasNext()) {
                    enoughRowsCollected = listBuilder.add((Object[])localBestRowIt.next());
                }
            }
            localBestRows = listBuilder.build();
        }
        return localBestRows;
    }

    @Override
    protected int getNumDocsScanned() {
        return this._numDocsScanned;
    }

    @Override
    protected String getExplainName() {
        return EXPLAIN_NAME;
    }
}

