/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountSmartHLLAggregationFunction;
import org.apache.pinot.segment.local.customobject.MinMaxRangePair;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class NonScanBasedAggregationOperator
extends BaseOperator<AggregationResultsBlock> {
    private static final String EXPLAIN_NAME = "AGGREGATE_NO_SCAN";
    private final AggregationFunction[] _aggregationFunctions;
    private final DataSource[] _dataSources;
    private final int _numTotalDocs;

    public NonScanBasedAggregationOperator(AggregationFunction[] aggregationFunctions, DataSource[] dataSources, int numTotalDocs) {
        this._aggregationFunctions = aggregationFunctions;
        this._dataSources = dataSources;
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected AggregationResultsBlock getNextBlock() {
        ArrayList<Object> aggregationResults = new ArrayList<Object>(this._aggregationFunctions.length);
        for (int i = 0; i < this._aggregationFunctions.length; ++i) {
            Object result;
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            DataSource dataSource = this._dataSources[i];
            switch (aggregationFunction.getType()) {
                case COUNT: {
                    result = (long)this._numTotalDocs;
                    break;
                }
                case MIN: 
                case MINMV: {
                    result = NonScanBasedAggregationOperator.getMinValue(dataSource);
                    break;
                }
                case MAX: 
                case MAXMV: {
                    result = NonScanBasedAggregationOperator.getMaxValue(dataSource);
                    break;
                }
                case MINMAXRANGE: 
                case MINMAXRANGEMV: {
                    result = new MinMaxRangePair(NonScanBasedAggregationOperator.getMinValue(dataSource).doubleValue(), NonScanBasedAggregationOperator.getMaxValue(dataSource).doubleValue());
                    break;
                }
                case DISTINCTCOUNT: 
                case DISTINCTCOUNTMV: {
                    result = NonScanBasedAggregationOperator.getDistinctValueSet(Objects.requireNonNull(dataSource.getDictionary()));
                    break;
                }
                case DISTINCTCOUNTHLL: 
                case DISTINCTCOUNTHLLMV: {
                    result = NonScanBasedAggregationOperator.getDistinctCountHLLResult(Objects.requireNonNull(dataSource.getDictionary()), (DistinctCountHLLAggregationFunction)aggregationFunction);
                    break;
                }
                case DISTINCTCOUNTRAWHLL: 
                case DISTINCTCOUNTRAWHLLMV: {
                    result = NonScanBasedAggregationOperator.getDistinctCountHLLResult(Objects.requireNonNull(dataSource.getDictionary()), ((DistinctCountRawHLLAggregationFunction)aggregationFunction).getDistinctCountHLLAggregationFunction());
                    break;
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    result = (long)Objects.requireNonNull(dataSource.getDictionary()).length();
                    break;
                }
                case DISTINCTCOUNTSMARTHLL: {
                    result = NonScanBasedAggregationOperator.getDistinctCountSmartHLLResult(Objects.requireNonNull(dataSource.getDictionary()), (DistinctCountSmartHLLAggregationFunction)aggregationFunction);
                    break;
                }
                default: {
                    throw new IllegalStateException("Non-scan based aggregation operator does not support function type: " + aggregationFunction.getType());
                }
            }
            aggregationResults.add(result);
        }
        return new AggregationResultsBlock(this._aggregationFunctions, aggregationResults);
    }

    private static Double getMinValue(DataSource dataSource) {
        Dictionary dictionary = dataSource.getDictionary();
        if (dictionary != null) {
            return NonScanBasedAggregationOperator.toDouble(dictionary.getMinVal());
        }
        return NonScanBasedAggregationOperator.toDouble(dataSource.getDataSourceMetadata().getMinValue());
    }

    private static Double getMaxValue(DataSource dataSource) {
        Dictionary dictionary = dataSource.getDictionary();
        if (dictionary != null) {
            return NonScanBasedAggregationOperator.toDouble(dictionary.getMaxVal());
        }
        return NonScanBasedAggregationOperator.toDouble(dataSource.getDataSourceMetadata().getMaxValue());
    }

    private static Double toDouble(Comparable<?> value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)((Object)value)).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private static Set getDistinctValueSet(Dictionary dictionary) {
        int dictionarySize = dictionary.length();
        switch (dictionary.getValueType()) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    intSet.add(dictionary.getIntValue(dictId));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    longSet.add(dictionary.getLongValue(dictId));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    floatSet.add(dictionary.getFloatValue(dictId));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    doubleSet.add(dictionary.getDoubleValue(dictId));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    stringSet.add((Object)dictionary.getStringValue(dictId));
                }
                return stringSet;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(dictionarySize);
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(dictId)));
                }
                return bytesSet;
            }
        }
        throw new IllegalStateException();
    }

    private static HyperLogLog getDistinctValueHLL(Dictionary dictionary, int log2m) {
        HyperLogLog hll = new HyperLogLog(log2m);
        int length = dictionary.length();
        for (int i = 0; i < length; ++i) {
            hll.offer(dictionary.get(i));
        }
        return hll;
    }

    private static HyperLogLog getDistinctCountHLLResult(Dictionary dictionary, DistinctCountHLLAggregationFunction function) {
        if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
            try {
                HyperLogLog hll = ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(dictionary.getBytesValue(0));
                int length = dictionary.length();
                for (int i = 1; i < length; ++i) {
                    hll.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(dictionary.getBytesValue(i)));
                }
                return hll;
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
            }
        }
        return NonScanBasedAggregationOperator.getDistinctValueHLL(dictionary, function.getLog2m());
    }

    private static Object getDistinctCountSmartHLLResult(Dictionary dictionary, DistinctCountSmartHLLAggregationFunction function) {
        if (dictionary.length() > function.getThreshold()) {
            return NonScanBasedAggregationOperator.getDistinctValueHLL(dictionary, function.getLog2m());
        }
        return NonScanBasedAggregationOperator.getDistinctValueSet(dictionary);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numTotalDocs, 0L, 0L, this._numTotalDocs);
    }
}

