/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionOnlyCombineOperator
extends BaseCombineOperator<SelectionResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionOnlyCombineOperator.class);
    private static final String EXPLAIN_NAME = "COMBINE_SELECT";
    private final int _numRowsToKeep;

    public SelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, queryContext, executorService);
        this._numRowsToKeep = queryContext.getLimit();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected BaseResultsBlock getNextBlock() {
        if (this._numRowsToKeep == 0) {
            BaseResultsBlock resultsBlock = (BaseResultsBlock)((Operator)this._operators.get(0)).nextBlock();
            CombineOperatorUtils.setExecutionStatistics(resultsBlock, this._operators, 0L, 1);
            return resultsBlock;
        }
        return super.getNextBlock();
    }

    @Override
    protected boolean isQuerySatisfied(SelectionResultsBlock resultsBlock) {
        return resultsBlock.getRows().size() == this._numRowsToKeep;
    }

    @Override
    protected void mergeResultsBlocks(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        Collection<Object[]> mergedRows = mergedBlock.getRows();
        Collection<Object[]> rowsToMerge = blockToMerge.getRows();
        assert (mergedRows != null && rowsToMerge != null);
        SelectionOperatorUtils.mergeWithoutOrdering(mergedRows, rowsToMerge, this._numRowsToKeep);
    }
}

