/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.utils.LoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByCombineOperator
extends BaseCombineOperator<GroupByResultsBlock> {
    public static final int MAX_TRIM_THRESHOLD = 1000000000;
    public static final int MAX_GROUP_BY_KEYS_MERGED_PER_INTERRUPTION_CHECK = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByCombineOperator.class);
    private static final String EXPLAIN_NAME = "COMBINE_GROUP_BY";
    private final int _trimSize;
    private final int _trimThreshold;
    private final int _numAggregationFunctions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final ConcurrentLinkedQueue<ProcessingException> _mergedProcessingExceptions = new ConcurrentLinkedQueue();
    private final CountDownLatch _operatorLatch;
    private volatile IndexedTable _indexedTable;
    private volatile boolean _numGroupsLimitReached;

    public GroupByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, GroupByCombineOperator.overrideMaxExecutionThreads(queryContext, operators.size()), executorService);
        int minTrimSize = queryContext.getMinServerGroupTrimSize();
        if (minTrimSize > 0) {
            int limit = queryContext.getLimit();
            this._trimSize = !queryContext.isServerReturnFinalResult() && queryContext.getOrderByExpressions() != null || queryContext.getHavingFilter() != null ? GroupByUtils.getTableCapacity(limit, minTrimSize) : limit;
            this._trimThreshold = queryContext.getGroupTrimThreshold();
        } else {
            this._trimSize = Integer.MAX_VALUE;
            this._trimThreshold = Integer.MAX_VALUE;
        }
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        this._numAggregationFunctions = aggregationFunctions.length;
        assert (this._queryContext.getGroupByExpressions() != null);
        this._numGroupByExpressions = this._queryContext.getGroupByExpressions().size();
        this._numColumns = this._numGroupByExpressions + this._numAggregationFunctions;
        this._operatorLatch = new CountDownLatch(this._numTasks);
    }

    private static QueryContext overrideMaxExecutionThreads(QueryContext queryContext, int numOperators) {
        int maxExecutionThreads = queryContext.getMaxExecutionThreads();
        if (maxExecutionThreads <= 0) {
            queryContext.setMaxExecutionThreads(numOperators);
        }
        return queryContext;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        while ((operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            Operator operator = (Operator)this._operators.get(operatorId);
            try {
                List<ProcessingException> processingExceptionsToMerge;
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                GroupByResultsBlock resultsBlock = (GroupByResultsBlock)operator.nextBlock();
                if (this._indexedTable == null) {
                    GroupByCombineOperator groupByCombineOperator = this;
                    synchronized (groupByCombineOperator) {
                        if (this._indexedTable == null) {
                            DataSchema dataSchema = resultsBlock.getDataSchema();
                            this._indexedTable = this._trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, this._queryContext, this._trimSize) : new ConcurrentIndexedTable(dataSchema, this._queryContext, this._trimSize, this._trimSize, this._trimThreshold);
                        }
                    }
                }
                if ((processingExceptionsToMerge = resultsBlock.getProcessingExceptions()) != null) {
                    this._mergedProcessingExceptions.addAll(processingExceptionsToMerge);
                }
                if (resultsBlock.isNumGroupsLimitReached()) {
                    this._numGroupsLimitReached = true;
                }
                Collection<IntermediateRecord> intermediateRecords = resultsBlock.getIntermediateRecords();
                int mergedKeys = 0;
                if (intermediateRecords == null) {
                    AggregationGroupByResult aggregationGroupByResult = resultsBlock.getAggregationGroupByResult();
                    if (aggregationGroupByResult == null) continue;
                    Iterator<GroupKeyGenerator.GroupKey> dicGroupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                    while (dicGroupKeyIterator.hasNext()) {
                        GroupKeyGenerator.GroupKey groupKey = dicGroupKeyIterator.next();
                        Object[] keys = groupKey._keys;
                        Object[] values = Arrays.copyOf(keys, this._numColumns);
                        int groupId = groupKey._groupId;
                        for (int i = 0; i < this._numAggregationFunctions; ++i) {
                            values[this._numGroupByExpressions + i] = aggregationGroupByResult.getResultForGroupId(i, groupId);
                        }
                        this._indexedTable.upsert(new Key(keys), new Record(values));
                        LoopUtils.checkMergePhaseInterruption((int)(++mergedKeys));
                    }
                    continue;
                }
                for (IntermediateRecord intermediateResult : intermediateRecords) {
                    this._indexedTable.upsert(intermediateResult._key, intermediateResult._record);
                    LoopUtils.checkMergePhaseInterruption((int)(++mergedKeys));
                }
            }
            finally {
                if (!(operator instanceof AcquireReleaseColumnsSegmentOperator)) continue;
                ((AcquireReleaseColumnsSegmentOperator)operator).release();
            }
        }
    }

    @Override
    protected void onException(Throwable t) {
        this._mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)t));
    }

    @Override
    protected void onFinish() {
        this._operatorLatch.countDown();
    }

    @Override
    protected BaseResultsBlock mergeResults() throws Exception {
        long timeoutMs = this._queryContext.getEndTimeMs() - System.currentTimeMillis();
        boolean opCompleted = this._operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (!opCompleted) {
            String errorMessage = String.format("Timed out while combining group-by order-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
            LOGGER.error(errorMessage);
            return new ExceptionResultsBlock(new TimeoutException(errorMessage));
        }
        IndexedTable indexedTable = this._indexedTable;
        if (!this._queryContext.isServerReturnFinalResult()) {
            indexedTable.finish(false);
        } else {
            indexedTable.finish(true, true);
        }
        GroupByResultsBlock mergedBlock = new GroupByResultsBlock(indexedTable);
        mergedBlock.setNumGroupsLimitReached(this._numGroupsLimitReached);
        mergedBlock.setNumResizes(indexedTable.getNumResizes());
        mergedBlock.setResizeTimeMs(indexedTable.getResizeTimeMs());
        if (!this._mergedProcessingExceptions.isEmpty()) {
            mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(this._mergedProcessingExceptions));
        }
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(GroupByResultsBlock mergedBlock, GroupByResultsBlock blockToMerge) {
    }
}

