/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.request.context.QueryContext;

public abstract class BaseResultsBlock
implements Block {
    private List<ProcessingException> _processingExceptions;
    private long _numTotalDocs;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;
    private int _numSegmentsProcessed;
    private int _numSegmentsMatched;
    private int _numConsumingSegmentsProcessed;
    private int _numConsumingSegmentsMatched;
    private long _executionThreadCpuTimeNs;
    private int _numServerThreads;

    @Nullable
    public List<ProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    public void setProcessingExceptions(List<ProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    public void addToProcessingExceptions(ProcessingException processingException) {
        if (this._processingExceptions == null) {
            this._processingExceptions = new ArrayList<ProcessingException>();
        }
        this._processingExceptions.add(processingException);
    }

    @VisibleForTesting
    public long getNumTotalDocs() {
        return this._numTotalDocs;
    }

    public void setNumTotalDocs(long numTotalDocs) {
        this._numTotalDocs = numTotalDocs;
    }

    @VisibleForTesting
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    @VisibleForTesting
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    @VisibleForTesting
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    @VisibleForTesting
    public int getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    public void setNumSegmentsProcessed(int numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    @VisibleForTesting
    public int getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    public void setNumSegmentsMatched(int numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    @VisibleForTesting
    public int getNumConsumingSegmentsProcessed() {
        return this._numConsumingSegmentsProcessed;
    }

    public void setNumConsumingSegmentsProcessed(int numConsumingSegmentsProcessed) {
        this._numConsumingSegmentsProcessed = numConsumingSegmentsProcessed;
    }

    @VisibleForTesting
    public int getNumConsumingSegmentsMatched() {
        return this._numConsumingSegmentsMatched;
    }

    public void setNumConsumingSegmentsMatched(int numConsumingSegmentsMatched) {
        this._numConsumingSegmentsMatched = numConsumingSegmentsMatched;
    }

    public long getExecutionThreadCpuTimeNs() {
        return this._executionThreadCpuTimeNs;
    }

    public void setExecutionThreadCpuTimeNs(long executionThreadCpuTimeNs) {
        this._executionThreadCpuTimeNs = executionThreadCpuTimeNs;
    }

    public int getNumServerThreads() {
        return this._numServerThreads;
    }

    public void setNumServerThreads(int numServerThreads) {
        this._numServerThreads = numServerThreads;
    }

    public abstract int getNumRows();

    @Nullable
    public abstract DataSchema getDataSchema(QueryContext var1);

    @Nullable
    public abstract Collection<Object[]> getRows(QueryContext var1);

    public abstract DataTable getDataTable(QueryContext var1) throws IOException;

    public Map<String, String> getResultsMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(DataTable.MetadataKey.TOTAL_DOCS.getName(), Long.toString(this._numTotalDocs));
        metadata.put(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName(), Long.toString(this._numDocsScanned));
        metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName(), Long.toString(this._numEntriesScannedInFilter));
        metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName(), Long.toString(this._numEntriesScannedPostFilter));
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName(), Integer.toString(this._numSegmentsProcessed));
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName(), Integer.toString(this._numSegmentsMatched));
        metadata.put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName(), Integer.toString(this._numConsumingSegmentsProcessed));
        metadata.put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_MATCHED.getName(), Integer.toString(this._numConsumingSegmentsMatched));
        return metadata;
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

