/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;

public class InstanceResponseOperator
extends BaseOperator<InstanceResponseBlock> {
    private static final String EXPLAIN_NAME = "INSTANCE_RESPONSE";
    private final BaseCombineOperator<?> _combineOperator;
    private final List<IndexSegment> _indexSegments;
    private final List<FetchContext> _fetchContexts;
    private final int _fetchContextSize;
    private final QueryContext _queryContext;

    public InstanceResponseOperator(BaseCombineOperator<?> combineOperator, List<IndexSegment> indexSegments, List<FetchContext> fetchContexts, QueryContext queryContext) {
        this._combineOperator = combineOperator;
        this._indexSegments = indexSegments;
        this._fetchContexts = fetchContexts;
        this._fetchContextSize = fetchContexts.size();
        this._queryContext = queryContext;
    }

    public static long calSystemActivitiesCpuTimeNs(long totalWallClockTimeNs, long multipleThreadCpuTimeNs, long mainThreadCpuTimeNs, int numServerThreads) {
        double perMultipleThreadCpuTimeNs = (double)multipleThreadCpuTimeNs * 1.0 / (double)numServerThreads;
        long systemActivitiesCpuTimeNs = Math.round((double)(totalWallClockTimeNs - mainThreadCpuTimeNs) - perMultipleThreadCpuTimeNs);
        return Math.max(systemActivitiesCpuTimeNs, 0L);
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        if (ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled()) {
            long startWallClockTimeNs = System.nanoTime();
            ThreadResourceUsageProvider mainThreadResourceUsageProvider = new ThreadResourceUsageProvider();
            BaseResultsBlock resultsBlock = this.getCombinedResults();
            InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(resultsBlock, this._queryContext);
            long mainThreadCpuTimeNs = mainThreadResourceUsageProvider.getThreadTimeNs();
            long totalWallClockTimeNs = System.nanoTime() - startWallClockTimeNs;
            long multipleThreadCpuTimeNs = resultsBlock.getExecutionThreadCpuTimeNs();
            int numServerThreads = resultsBlock.getNumServerThreads();
            long systemActivitiesCpuTimeNs = InstanceResponseOperator.calSystemActivitiesCpuTimeNs(totalWallClockTimeNs, multipleThreadCpuTimeNs, mainThreadCpuTimeNs, numServerThreads);
            long threadCpuTimeNs = mainThreadCpuTimeNs + multipleThreadCpuTimeNs;
            instanceResponseBlock.addMetadata(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), String.valueOf(threadCpuTimeNs));
            instanceResponseBlock.addMetadata(DataTable.MetadataKey.SYSTEM_ACTIVITIES_CPU_TIME_NS.getName(), String.valueOf(systemActivitiesCpuTimeNs));
            return instanceResponseBlock;
        }
        return new InstanceResponseBlock(this.getCombinedResults(), this._queryContext);
    }

    private BaseResultsBlock getCombinedResults() {
        try {
            this.prefetchAll();
            BaseResultsBlock baseResultsBlock = (BaseResultsBlock)this._combineOperator.nextBlock();
            return baseResultsBlock;
        }
        finally {
            this.releaseAll();
        }
    }

    private void prefetchAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._indexSegments.get(i).prefetch(this._fetchContexts.get(i));
        }
    }

    private void releaseAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._indexSegments.get(i).release(this._fetchContexts.get(i));
        }
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._combineOperator);
    }
}

