/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.geospatial.transform.function.ScalarFunctions;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.utils.BooleanUtils;

public class StPointFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "ST_Point";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private byte[][] _results;
    private boolean _isGeography;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 || arguments.size() == 3 ? 1 : 0) != 0, (String)"2 or 3 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        this._firstArgument = transformFunction;
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        this._secondArgument = transformFunction;
        if (arguments.size() == 3) {
            transformFunction = arguments.get(2);
            Preconditions.checkArgument((boolean)(transformFunction instanceof LiteralTransformFunction), (String)"Third argument must be a literal of integer: %s", (Object)this.getName());
            this._isGeography = BooleanUtils.toBoolean((String)((LiteralTransformFunction)transformFunction).getLiteral());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BYTES_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new byte[10000][];
        }
        double[] firstValues = this._firstArgument.transformToDoubleValuesSV(projectionBlock);
        double[] secondValues = this._secondArgument.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            this._results[i] = ScalarFunctions.stPoint(firstValues[i], secondValues[i], this._isGeography);
        }
        return this._results;
    }
}

