/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;

public class ScalarFunctions {
    private ScalarFunctions() {
    }

    @ScalarFunction
    public static byte[] stPoint(double x, double y) {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y)));
    }

    @ScalarFunction
    public static byte[] stPoint(double x, double y, boolean isGeography) {
        Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y));
        if (isGeography) {
            GeometryUtils.setGeography((Geometry)point);
        }
        return GeometrySerializer.serialize((Geometry)point);
    }

    @ScalarFunction
    public static byte[] stGeomFromText(String wkt) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_WKT_READER.read(wkt));
    }

    @ScalarFunction
    public static byte[] stGeogFromText(String wkt) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOGRAPHY_WKT_READER.read(wkt));
    }

    @ScalarFunction
    public static byte[] stGeomFromWKB(byte[] wkb) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_WKB_READER.read(wkb));
    }

    @ScalarFunction
    public static byte[] stGeogFromWKB(byte[] wkb) throws ParseException {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOGRAPHY_WKB_READER.read(wkb));
    }

    @ScalarFunction
    public static String stAsText(byte[] bytes) {
        return GeometryUtils.WKT_WRITER.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static byte[] stAsBinary(byte[] bytes) {
        return GeometryUtils.WKB_WRITER.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static byte[] toSphericalGeography(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeography((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }

    @ScalarFunction
    public static byte[] toGeometry(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeometry((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }

    @ScalarFunction
    public static long geoToH3(double longitude, double latitude, int resolution) {
        return H3Utils.H3_CORE.geoToH3(latitude, longitude, resolution);
    }
}

