/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.evaluators;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public final class DefaultJsonPathEvaluator
implements JsonPathEvaluator {
    private static final ObjectMapper OBJECT_MAPPER_WITH_BIG_DECIMAL = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private static final ParseContext JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider(OBJECT_MAPPER_WITH_BIG_DECIMAL)).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private static final int[] EMPTY_INTS = new int[0];
    private static final long[] EMPTY_LONGS = new long[0];
    private static final float[] EMPTY_FLOATS = new float[0];
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private final JsonPath _jsonPath;
    private final Object _defaultValue;

    public static JsonPathEvaluator create(String jsonPath, @Nullable Object defaultValue) {
        try {
            return new DefaultJsonPathEvaluator(JsonPathCache.INSTANCE.getOrCompute(jsonPath), defaultValue);
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultJsonPathEvaluator(JsonPath jsonPath, @Nullable Object defaultValue) {
        this._jsonPath = jsonPath;
        this._defaultValue = defaultValue;
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, int[] valueBuffer) {
        int defaultValue;
        int n = defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).intValue() : 0;
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytes(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromString(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromString(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromBytes(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, long[] valueBuffer) {
        long defaultValue;
        long l = defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).longValue() : 0L;
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytes(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromString(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromString(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromBytes(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, float[] valueBuffer) {
        float defaultValue;
        float f = defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).floatValue() : 0.0f;
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytes(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromString(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromString(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromBytes(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, double[] valueBuffer) {
        double defaultValue;
        double d = defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).doubleValue() : 0.0;
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytes(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromString(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromString(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromBytes(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, BigDecimal[] valueBuffer) {
        BigDecimal defaultValue;
        BigDecimal bigDecimal = defaultValue = this._defaultValue instanceof BigDecimal ? (BigDecimal)this._defaultValue : BigDecimal.ZERO;
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytesWithExactBigDecimal(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromStringWithExactBigDecimal(dictionary, dictIdsBuffer[i]), defaultValue, valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, (Object)this.extractFromStringWithExactBigDecimal(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, (Object)this.extractFromBytesWithExactBigDecimal(reader, context, docIds[i]), defaultValue, valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, String[] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processValue(i, this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processValue(i, this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, int[][] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, long[][] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, float[][] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, double[][] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public <T extends ForwardIndexReaderContext> void evaluateBlock(int[] docIds, int length, ForwardIndexReader<T> reader, T context, Dictionary dictionary, int[] dictIdsBuffer, String[][] valueBuffer) {
        if (reader.isDictionaryEncoded()) {
            reader.readDictIds(docIds, length, dictIdsBuffer, context);
            if (dictionary.getValueType() == FieldSpec.DataType.BYTES) {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromBytes(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.processList(i, (List)this.extractFromString(dictionary, dictIdsBuffer[i]), valueBuffer);
                }
            }
        } else {
            switch (reader.getStoredType()) {
                case STRING: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromString(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < length; ++i) {
                        this.processList(i, (List)this.extractFromBytes(reader, context, docIds[i]), valueBuffer);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Nullable
    private <T> T extractFromBytes(Dictionary dictionary, int dictId) {
        try {
            return (T)JSON_PARSER_CONTEXT.parseUtf8(dictionary.getBytesValue(dictId)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <T, R extends ForwardIndexReaderContext> T extractFromBytes(ForwardIndexReader<R> reader, R context, int docId) {
        try {
            return (T)JSON_PARSER_CONTEXT.parseUtf8(reader.getBytes(docId, context)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <T> T extractFromBytesWithExactBigDecimal(Dictionary dictionary, int dictId) {
        try {
            return (T)JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parseUtf8(dictionary.getBytesValue(dictId)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <R extends ForwardIndexReaderContext> BigDecimal extractFromBytesWithExactBigDecimal(ForwardIndexReader<R> reader, R context, int docId) {
        try {
            return (BigDecimal)JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parseUtf8(reader.getBytes(docId, context)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <T> T extractFromString(Dictionary dictionary, int dictId) {
        try {
            return (T)JSON_PARSER_CONTEXT.parse(dictionary.getStringValue(dictId)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <T, R extends ForwardIndexReaderContext> T extractFromString(ForwardIndexReader<R> reader, R context, int docId) {
        try {
            return (T)JSON_PARSER_CONTEXT.parseUtf8(reader.getBytes(docId, context)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <T> T extractFromStringWithExactBigDecimal(Dictionary dictionary, int dictId) {
        try {
            return (T)JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parse(dictionary.getStringValue(dictId)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private <R extends ForwardIndexReaderContext> BigDecimal extractFromStringWithExactBigDecimal(ForwardIndexReader<R> reader, R context, int docId) {
        try {
            return (BigDecimal)JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parseUtf8(reader.getBytes(docId, context)).read(this._jsonPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void processValue(int index, Object value, int defaultValue, int[] valueBuffer) {
        if (value instanceof Number) {
            valueBuffer[index] = ((Number)value).intValue();
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = defaultValue;
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = Integer.parseInt(value.toString());
        }
    }

    private void processValue(int index, Object value, long defaultValue, long[] valueBuffer) {
        if (value instanceof Number) {
            valueBuffer[index] = ((Number)value).longValue();
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = defaultValue;
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = (long)Double.parseDouble(value.toString());
        }
    }

    private void processValue(int index, Object value, float defaultValue, float[] valueBuffer) {
        if (value instanceof Number) {
            valueBuffer[index] = ((Number)value).floatValue();
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = defaultValue;
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = Float.parseFloat(value.toString());
        }
    }

    private void processValue(int index, Object value, double defaultValue, double[] valueBuffer) {
        if (value instanceof Number) {
            valueBuffer[index] = ((Number)value).doubleValue();
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = defaultValue;
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = Double.parseDouble(value.toString());
        }
    }

    private void processValue(int index, Object value, BigDecimal defaultValue, BigDecimal[] valueBuffer) {
        if (value instanceof BigDecimal) {
            valueBuffer[index] = (BigDecimal)value;
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = defaultValue;
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = new BigDecimal(value.toString());
        }
    }

    private void processValue(int index, Object value, String[] valueBuffer) {
        if (value instanceof String) {
            valueBuffer[index] = (String)value;
        } else if (value == null) {
            if (this._defaultValue != null) {
                valueBuffer[index] = this._defaultValue.toString();
            } else {
                this.throwPathNotFoundException();
            }
        } else {
            valueBuffer[index] = JsonUtils.objectToJsonNode((Object)value).toString();
        }
    }

    private void processList(int index, List<Integer> value, int[][] valuesBuffer) {
        if (value == null) {
            valuesBuffer[index] = EMPTY_INTS;
        } else {
            int numValues = value.size();
            int[] values = new int[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = value.get(j);
            }
            valuesBuffer[index] = values;
        }
    }

    private void processList(int index, List<Long> value, long[][] valuesBuffer) {
        if (value == null) {
            valuesBuffer[index] = EMPTY_LONGS;
        } else {
            int numValues = value.size();
            long[] values = new long[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = value.get(j);
            }
            valuesBuffer[index] = values;
        }
    }

    private void processList(int index, List<Float> value, float[][] valuesBuffer) {
        if (value == null) {
            valuesBuffer[index] = EMPTY_FLOATS;
        } else {
            int numValues = value.size();
            float[] values = new float[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = value.get(j).floatValue();
            }
            valuesBuffer[index] = values;
        }
    }

    private void processList(int index, List<Double> value, double[][] valuesBuffer) {
        if (value == null) {
            valuesBuffer[index] = EMPTY_DOUBLES;
        } else {
            int numValues = value.size();
            double[] values = new double[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = value.get(j);
            }
            valuesBuffer[index] = values;
        }
    }

    private void processList(int index, List<String> value, String[][] valuesBuffer) {
        if (value == null) {
            valuesBuffer[index] = EMPTY_STRINGS;
        } else {
            int numValues = value.size();
            String[] values = new String[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = value.get(j);
            }
            valuesBuffer[index] = values;
        }
    }

    private void throwPathNotFoundException() {
        throw new IllegalArgumentException("Illegal Json Path: " + this._jsonPath.getPath() + " does not match document");
    }
}

