/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV4;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.core.common.datatable.BaseDataTableBuilder;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class DataTableBuilderV4
extends BaseDataTableBuilder {
    private final Object2IntOpenHashMap<String> _dictionary = new Object2IntOpenHashMap();

    public DataTableBuilderV4(DataSchema dataSchema) {
        super(dataSchema, 4);
    }

    @Override
    public void setColumn(int colId, String value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        int dictId = this._dictionary.computeIntIfAbsent((Object)value, k -> this._dictionary.size());
        this._currentRowDataByteBuffer.putInt(dictId);
    }

    @Override
    public void setColumn(int colId, ByteArray value) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = value.getBytes();
        this._currentRowDataByteBuffer.putInt(bytes.length);
        this._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    @Override
    public void setColumn(int colId, String[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (String value : values) {
            int dictId = this._dictionary.computeIntIfAbsent((Object)value, k -> this._dictionary.size());
            this._variableSizeDataOutputStream.writeInt(dictId);
        }
    }

    @Override
    public void setNullRowIds(@Nullable RoaringBitmap nullRowIds) throws IOException {
        this._fixedSizeDataOutputStream.writeInt(this._variableSizeDataByteArrayOutputStream.size());
        if (nullRowIds == null || nullRowIds.isEmpty()) {
            this._fixedSizeDataOutputStream.writeInt(0);
        } else {
            byte[] bitmapBytes = RoaringBitmapUtils.serialize((RoaringBitmap)nullRowIds);
            this._fixedSizeDataOutputStream.writeInt(bitmapBytes.length);
            this._variableSizeDataByteArrayOutputStream.write(bitmapBytes);
        }
    }

    @Override
    public DataTable build() {
        String[] reverseDictionary = new String[this._dictionary.size()];
        for (Object2IntMap.Entry entry : this._dictionary.object2IntEntrySet()) {
            reverseDictionary[entry.getIntValue()] = (String)entry.getKey();
        }
        return new DataTableImplV4(this._numRows, this._dataSchema, reverseDictionary, this._fixedSizeDataByteArrayOutputStream.toByteArray(), this._variableSizeDataByteArrayOutputStream.toByteArray());
    }
}

