/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV2;
import org.apache.pinot.common.datatable.DataTableImplV3;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.BaseDataTableBuilder;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class DataTableBuilderV2V3
extends BaseDataTableBuilder {
    private final Map<String, Map<String, Integer>> _dictionaryMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<Integer, String>> _reverseDictionaryMap = new HashMap<String, Map<Integer, String>>();

    public DataTableBuilderV2V3(DataSchema dataSchema, int version) {
        super(dataSchema, version);
        Preconditions.checkArgument((version <= 3 ? 1 : 0) != 0);
    }

    @Override
    public void setColumn(int colId, String value) {
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        Integer dictId = dictionary.get(value);
        if (dictId == null) {
            dictId = dictionary.size();
            dictionary.put(value, dictId);
            this._reverseDictionaryMap.get(columnName).put(dictId, value);
        }
        this._currentRowDataByteBuffer.putInt(dictId);
    }

    @Override
    public void setColumn(int colId, ByteArray value) throws IOException {
        this.setColumn(colId, value.toHexString());
    }

    @Override
    public void setColumn(int colId, String[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        for (String value : values) {
            Integer dictId = dictionary.get(value);
            if (dictId == null) {
                dictId = dictionary.size();
                dictionary.put(value, dictId);
                this._reverseDictionaryMap.get(columnName).put(dictId, value);
            }
            this._variableSizeDataOutputStream.writeInt(dictId);
        }
    }

    @Override
    public void setNullRowIds(@Nullable RoaringBitmap nullRowIds) throws IOException {
        throw new UnsupportedOperationException("Not supported before DataTable V4");
    }

    @Override
    public DataTable build() {
        byte[] fixedSizeDataBytes = this._fixedSizeDataByteArrayOutputStream.toByteArray();
        byte[] variableSizeDataBytes = this._variableSizeDataByteArrayOutputStream.toByteArray();
        if (this._version == 2) {
            return new DataTableImplV2(this._numRows, this._dataSchema, this._reverseDictionaryMap, fixedSizeDataBytes, variableSizeDataBytes);
        }
        return new DataTableImplV3(this._numRows, this._dataSchema, this._reverseDictionaryMap, fixedSizeDataBytes, variableSizeDataBytes);
    }
}

