/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.auth;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.BcryptUtils;
import org.apache.pinot.core.auth.BasicAuthPrincipal;
import org.apache.pinot.core.auth.ZkBasicAuthPrincipal;
import org.apache.pinot.spi.config.user.UserConfig;
import org.apache.pinot.spi.env.PinotConfiguration;

public final class BasicAuthUtils {
    private static final String PASSWORD = "password";
    private static final String PERMISSIONS = "permissions";
    private static final String TABLES = "tables";
    private static final String ALL = "*";

    private BasicAuthUtils() {
    }

    public static List<BasicAuthPrincipal> extractBasicAuthPrincipals(PinotConfiguration configuration, String prefix) {
        String principalNames = configuration.getProperty(prefix);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)principalNames), (Object)"must provide principals");
        return Arrays.stream(principalNames.split(",")).map(rawName -> {
            String name = rawName.trim();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"%s is not a valid name", (Object)name);
            String password = configuration.getProperty(String.format("%s.%s.%s", prefix, name, PASSWORD));
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"must provide a password for %s", (Object)name);
            Set<String> tables = BasicAuthUtils.extractSet(configuration, String.format("%s.%s.%s", prefix, name, TABLES));
            Set<String> permissions = BasicAuthUtils.extractSet(configuration, String.format("%s.%s.%s", prefix, name, PERMISSIONS));
            return new BasicAuthPrincipal(name, BasicAuthUtils.toBasicAuthToken(name, password), tables, permissions);
        }).collect(Collectors.toList());
    }

    public static List<ZkBasicAuthPrincipal> extractBasicAuthPrincipals(List<UserConfig> userConfigList) {
        return userConfigList.stream().map(user -> {
            String name = user.getUserName().trim();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"%s is not a valid username", (Object)name);
            String password = user.getPassword().trim();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"must provide a password for %s", (Object)name);
            String component = user.getComponentType().toString();
            String role = user.getRoleType().toString();
            Set<String> tables = Optional.ofNullable(user.getTables()).orElseGet(() -> Collections.emptyList()).stream().collect(Collectors.toSet());
            Set<String> permissions = Optional.ofNullable(user.getPermissios()).orElseGet(() -> Collections.emptyList()).stream().map(x -> x.toString()).collect(Collectors.toSet());
            return new ZkBasicAuthPrincipal(name, BasicAuthUtils.toBasicAuthToken(name, password), password, component, role, tables, permissions);
        }).collect(Collectors.toList());
    }

    private static Set<String> extractSet(PinotConfiguration configuration, String key) {
        String input = configuration.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)input) && !ALL.equals(input)) {
            return Arrays.stream(input.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    public static String toBasicAuthToken(String name, String password) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        String identifier = String.format("%s:%s", name, password);
        return BasicAuthUtils.normalizeBase64Token(String.format("Basic %s", Base64.getEncoder().encodeToString(identifier.getBytes())));
    }

    public static String decodeBasicAuthToken(String auth) {
        if (StringUtils.isBlank((CharSequence)auth)) {
            return null;
        }
        String replacedAuth = StringUtils.replace((String)auth, (String)"Basic ", (String)"");
        byte[] decodedBytes = Base64.getDecoder().decode(replacedAuth);
        String decodedString = new String(decodedBytes);
        return decodedString;
    }

    public static String extractUsername(String auth) {
        String decodedString = BasicAuthUtils.decodeBasicAuthToken(auth);
        return StringUtils.split((String)decodedString, (String)":")[0];
    }

    public static String extractPassword(String auth) {
        String decodedString = BasicAuthUtils.decodeBasicAuthToken(auth);
        return StringUtils.split((String)decodedString, (String)":")[1];
    }

    public static String toEncryptBasicAuthToken(String auth) {
        if (StringUtils.isBlank((CharSequence)auth)) {
            return null;
        }
        String replacedAuth = StringUtils.replace((String)auth, (String)"Basic ", (String)"");
        byte[] decodedBytes = Base64.getDecoder().decode(replacedAuth);
        String decodedString = new String(decodedBytes);
        String[] cretential = StringUtils.split((String)decodedString, (String)":");
        String rawUsername = cretential[0];
        String rawPassword = cretential[1];
        String encryptedPassword = BcryptUtils.encrypt((String)rawPassword);
        return BasicAuthUtils.toBasicAuthToken(rawUsername, encryptedPassword);
    }

    @Nullable
    public static String normalizeBase64Token(String token) {
        if (token == null) {
            return null;
        }
        return StringUtils.remove((String)token.trim(), (char)'=');
    }
}

