/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;

public abstract class TaskAssignmentCalculator {
    public abstract Set<Integer> getAllTaskPartitions(JobConfig var1, JobContext var2, WorkflowConfig var3, WorkflowContext var4, Map<String, IdealState> var5);

    @Deprecated
    public abstract Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput var1, ResourceAssignment var2, Collection<String> var3, JobConfig var4, JobContext var5, WorkflowConfig var6, WorkflowContext var7, Set<Integer> var8, Map<String, IdealState> var9);

    public abstract Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput var1, Collection<String> var2, JobConfig var3, JobContext var4, WorkflowConfig var5, WorkflowContext var6, Set<Integer> var7, Map<String, IdealState> var8);

    public static String getQuotaType(WorkflowConfig workflowConfig, JobConfig jobConfig) {
        String workflowType = workflowConfig.getWorkflowType();
        if (workflowType == null || workflowType.equals("")) {
            String jobType = jobConfig.getJobType();
            if (jobType == null || jobType.equals("")) {
                return "DEFAULT";
            }
            return jobType;
        }
        return workflowType;
    }

    public Set<Integer> getRemovedPartitions(JobConfig jobConfig, JobContext jobContext, Set<Integer> allPartitions) {
        HashSet<Integer> deletedPartitions = new HashSet<Integer>();
        for (Integer partition : jobContext.getPartitionSet()) {
            String partitionID = jobContext.getTaskIdForPartition(partition);
            if (jobConfig.getTaskConfigMap().containsKey(partitionID)) continue;
            deletedPartitions.add(partition);
        }
        return deletedPartitions;
    }

    public Set<Integer> getAllTaskPartitionsDefault(JobConfig jobCfg, JobContext jobCtx) {
        Map<String, TaskConfig> taskMap = jobCfg.getTaskConfigMap();
        Map<String, Integer> taskIdMap = jobCtx.getTaskIdPartitionMap();
        Set<Integer> existingPartitions = jobCtx.getPartitionSet();
        HashSet<Integer> missingPartitions = new HashSet<Integer>();
        if (existingPartitions.size() != 0) {
            for (int pId = 0; pId < Collections.max(existingPartitions); ++pId) {
                if (existingPartitions.contains(pId)) continue;
                missingPartitions.add(pId);
            }
        }
        for (TaskConfig taskCfg : taskMap.values()) {
            String taskId = taskCfg.getId();
            if (taskIdMap.containsKey(taskId)) continue;
            int nextPartition = jobCtx.getPartitionSet().size();
            if (missingPartitions.size() != 0) {
                nextPartition = (Integer)missingPartitions.iterator().next();
                missingPartitions.remove(nextPartition);
            }
            jobCtx.setTaskIdForPartition(nextPartition, taskId);
        }
        return jobCtx.getPartitionSet();
    }
}

