/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class NodeMaxPartitionLimitConstraint
extends HardConstraint {
    NodeMaxPartitionLimitConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        boolean exceedMaxPartitionLimit = node.getMaxPartition() < 0 || node.getAssignedReplicaCount() < node.getMaxPartition();
        boolean exceedResourceMaxPartitionLimit = replica.getResourceMaxPartitionsPerInstance() < 0 || node.getAssignedPartitionsByResource(replica.getResourceName()).size() < replica.getResourceMaxPartitionsPerInstance();
        return exceedMaxPartitionLimit && exceedResourceMaxPartitionLimit;
    }

    @Override
    String getDescription() {
        return "Cannot exceed the maximum number of partitions limitation on node";
    }
}

