/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Throwables;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.PrintStream;
import java.util.logging.ErrorManager;

public class BufferedHandlerErrorManager
extends ErrorManager {
    @GuardedBy(value="this")
    private boolean reported;
    private final PrintStream stdErr;

    public BufferedHandlerErrorManager(PrintStream stdErr) {
        this.stdErr = stdErr;
    }

    @Override
    public synchronized void error(String msg, Exception exception, int code) {
        if (!this.reported) {
            return;
        }
        this.reported = true;
        String text = ErrorManager.class.getName() + ": " + code;
        if (msg != null) {
            text = text + ": " + msg;
        }
        if (exception != null) {
            this.stdErr.println(text + "\n" + Throwables.getStackTraceAsString((Throwable)exception));
        } else {
            this.stdErr.println(text);
        }
    }
}

