/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.google.common.base.Suppliers;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.mapping.CachingIdentifierMapping;
import io.trino.plugin.base.mapping.DefaultIdentifierMapping;
import io.trino.plugin.base.mapping.ForwardingIdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMappingRules;
import io.trino.plugin.base.mapping.MappingConfig;
import io.trino.plugin.base.mapping.RuleBasedIdentifierMapping;
import io.trino.plugin.base.util.JsonUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class IdentifierMappingModule
extends AbstractConfigurationAwareModule {
    private static final Logger log = Logger.get(IdentifierMappingModule.class);

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(MappingConfig.class);
        binder.bind(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
        MappingConfig config = (MappingConfig)this.buildConfigObject(MappingConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, CachingIdentifierMapping.class);
        if (config.isCaseInsensitiveNameMatching()) {
            binder.bind(IdentifierMapping.class).annotatedWith(ForCachingIdentifierMapping.class).to(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
            binder.bind(IdentifierMapping.class).annotatedWith(ForRuleBasedIdentifierMapping.class).to(CachingIdentifierMapping.class).in(Scopes.SINGLETON);
            binder.bind(CachingIdentifierMapping.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(IdentifierMapping.class).annotatedWith(ForRuleBasedIdentifierMapping.class).to(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
        }
        if (config.getCaseInsensitiveNameMatchingConfigFile().isPresent()) {
            this.install((Module)new RuleBasedIdentifierMappingModule());
        } else {
            binder.bind(IdentifierMapping.class).to(Key.get(IdentifierMapping.class, ForRuleBasedIdentifierMapping.class)).in(Scopes.SINGLETON);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForCachingIdentifierMapping {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForRuleBasedIdentifierMapping {
    }

    private static final class RuleBasedIdentifierMappingModule
    extends AbstractConfigurationAwareModule {
        private RuleBasedIdentifierMappingModule() {
        }

        protected void setup(Binder binder) {
        }

        @Singleton
        @Provides
        public IdentifierMapping getIdentifierMapping(CatalogName catalogName, @ForRuleBasedIdentifierMapping IdentifierMapping identifierMapping, MappingConfig config) {
            String configFile = config.getCaseInsensitiveNameMatchingConfigFile().orElseThrow(() -> new IllegalStateException("Missing case insensitive matching config file"));
            Optional<Duration> refreshPeriod = config.getCaseInsensitiveNameMatchingConfigFileRefreshPeriod();
            if (refreshPeriod.isPresent()) {
                return ForwardingIdentifierMapping.of((Supplier<IdentifierMapping>)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing identifier mapping for %s from %s", new Object[]{catalogName, configFile});
                    return new RuleBasedIdentifierMapping(RuleBasedIdentifierMappingModule.createRules(configFile), identifierMapping);
                }, (long)refreshPeriod.get().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return new RuleBasedIdentifierMapping(RuleBasedIdentifierMappingModule.createRules(configFile), identifierMapping);
        }

        private static IdentifierMappingRules createRules(String configFile) {
            return JsonUtils.parseJson(Paths.get(configFile, new String[0]), IdentifierMappingRules.class);
        }
    }
}

