/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.spi.Page;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorState;
import java.util.List;
import java.util.Optional;

public class ClassLoaderSafeTableFunctionDataProcessor
implements TableFunctionDataProcessor {
    private final TableFunctionDataProcessor delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeTableFunctionDataProcessor(TableFunctionDataProcessor delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public TableFunctionProcessorState process(List<Optional<Page>> input) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableFunctionProcessorState tableFunctionProcessorState = this.delegate.process(input);
            return tableFunctionProcessorState;
        }
    }
}

