/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;

public final class PinotQueryBuilder {
    private PinotQueryBuilder() {
    }

    public static String generatePql(PinotTableHandle tableHandle, List<PinotColumnHandle> columnHandles, Optional<String> tableNameSuffix, Optional<String> timePredicate, int limitForSegmentQueries) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        StringBuilder pqlBuilder = new StringBuilder();
        Object quotedColumnNames = columnHandles.isEmpty() ? ImmutableList.of((Object)"*") : (List)columnHandles.stream().map(column -> PinotQueryBuilder.quoteIdentifier(column.getColumnName())).collect(ImmutableList.toImmutableList());
        pqlBuilder.append("SELECT ");
        pqlBuilder.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)quotedColumnNames)).append(" FROM ").append(PinotQueryBuilder.getTableName(tableHandle, tableNameSuffix)).append(" ");
        PinotQueryBuilder.generateFilterPql(pqlBuilder, tableHandle, timePredicate);
        OptionalLong appliedLimit = tableHandle.getLimit();
        long limit = limitForSegmentQueries + 1;
        if (appliedLimit.isPresent()) {
            limit = Math.min(limit, appliedLimit.getAsLong());
        }
        pqlBuilder.append(" LIMIT ").append(limit);
        return pqlBuilder.toString();
    }

    private static String getTableName(PinotTableHandle tableHandle, Optional<String> tableNameSuffix) {
        if (tableNameSuffix.isPresent()) {
            return tableHandle.getTableName() + tableNameSuffix.get();
        }
        return tableHandle.getTableName();
    }

    private static void generateFilterPql(StringBuilder pqlBuilder, PinotTableHandle tableHandle, Optional<String> timePredicate) {
        Optional<String> filterClause = PinotQueryBuilder.getFilterClause(tableHandle.getConstraint(), timePredicate, false);
        if (filterClause.isPresent()) {
            pqlBuilder.append(" WHERE ").append(filterClause.get());
        }
    }

    public static Optional<String> getFilterClause(TupleDomain<ColumnHandle> tupleDomain, Optional<String> timePredicate, boolean forHavingClause) {
        Preconditions.checkState((!tupleDomain.isNone() ? 1 : 0) != 0, (Object)"Pinot does not support 1 = 0 syntax, as a workaround use <column> != <column>");
        ImmutableList.Builder conjunctsBuilder = ImmutableList.builder();
        Preconditions.checkState((forHavingClause && timePredicate.isEmpty() || !forHavingClause ? 1 : 0) != 0, (Object)"Unexpected time predicate with having clause");
        timePredicate.ifPresent(arg_0 -> ((ImmutableList.Builder)conjunctsBuilder).add(arg_0));
        Map domains = (Map)tupleDomain.getDomains().orElseThrow();
        for (Map.Entry entry : domains.entrySet()) {
            PinotColumnHandle pinotColumnHandle = (PinotColumnHandle)entry.getKey();
            if (forHavingClause != pinotColumnHandle.isAggregate()) continue;
            PinotQueryBuilder.toPredicate(pinotColumnHandle, (Domain)entry.getValue()).ifPresent(arg_0 -> ((ImmutableList.Builder)conjunctsBuilder).add(arg_0));
        }
        ImmutableList conjuncts = conjunctsBuilder.build();
        if (!conjuncts.isEmpty()) {
            return Optional.of(Joiner.on((String)" AND ").join((Iterable)conjuncts));
        }
        return Optional.empty();
    }

    private static Optional<String> toPredicate(PinotColumnHandle pinotColumnHandle, Domain domain) {
        Object complement;
        String predicateArgument = pinotColumnHandle.isAggregate() ? pinotColumnHandle.getExpression() : PinotQueryBuilder.quoteIdentifier(pinotColumnHandle.getColumnName());
        Object valueSet = domain.getValues();
        if (valueSet.isNone()) {
            Verify.verify((!domain.isNullAllowed() ? 1 : 0) != 0, (String)"IS NULL is not supported due to different null handling semantics. See https://docs.pinot.apache.org/developers/advanced/null-value-support", (Object[])new Object[0]);
            return Optional.of(String.format("(%s != %s)", predicateArgument, predicateArgument));
        }
        if (valueSet.isAll()) {
            Verify.verify((boolean)domain.isNullAllowed(), (String)"IS NOT NULL is not supported due to different null handling semantics. See https://docs.pinot.apache.org/developers/advanced/null-value-support", (Object[])new Object[0]);
            return Optional.empty();
        }
        Verify.verify((!domain.getValues().getRanges().getOrderedRanges().isEmpty() && !domain.isNullAllowed() ? 1 : 0) != 0, (String)"IS NULL is not supported due to different null handling semantics. See https://docs.pinot.apache.org/developers/advanced/null-value-support", (Object[])new Object[0]);
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        boolean invertPredicate = false;
        if (!valueSet.isDiscreteSet() && (complement = domain.getValues().complement()).isDiscreteSet()) {
            invertPredicate = complement.isDiscreteSet();
            valueSet = complement;
        }
        for (Range range : valueSet.getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(PinotQueryBuilder.convertValue(range.getType(), range.getSingleValue()));
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                rangeConjuncts.add(PinotQueryBuilder.toConjunct(predicateArgument, range.isLowInclusive() ? ">=" : ">", PinotQueryBuilder.convertValue(range.getType(), range.getLowBoundedValue())));
            }
            if (!range.isHighUnbounded()) {
                rangeConjuncts.add(PinotQueryBuilder.toConjunct(predicateArgument, range.isHighInclusive() ? "<=" : "<", PinotQueryBuilder.convertValue(range.getType(), range.getHighBoundedValue())));
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            operator = invertPredicate ? "!=" : "=";
            disjuncts.add(PinotQueryBuilder.toConjunct(predicateArgument, operator, Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            operator = invertPredicate ? "NOT IN" : "IN";
            disjuncts.add(PinotQueryBuilder.inClauseValues(predicateArgument, operator, singleValues));
        }
        return Optional.of("(" + Joiner.on((String)" OR ").join(disjuncts) + ")");
    }

    private static Object convertValue(Type type, Object value) {
        if (type instanceof RealType) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type instanceof VarcharType) {
            return ((Slice)value).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return Hex.encodeHexString((byte[])((Slice)value).getBytes());
        }
        if (type instanceof TimestampType) {
            return PinotQueryBuilder.toMillis((Long)value);
        }
        return value;
    }

    private static Long toMillis(Long value) {
        if (value == null) {
            return null;
        }
        return Timestamps.epochMicrosToMillisWithRounding((long)value);
    }

    private static String toConjunct(String columnName, String operator, Object value) {
        if (value instanceof Slice) {
            value = ((Slice)value).toStringUtf8();
        }
        return String.format("%s %s %s", columnName, operator, PinotQueryBuilder.singleQuote(value));
    }

    private static String inClauseValues(String columnName, String operator, List<Object> singleValues) {
        return String.format("%s %s (%s)", columnName, operator, singleValues.stream().map(PinotQueryBuilder::singleQuote).collect(Collectors.joining(", ")));
    }

    private static String singleQuote(Object value) {
        return String.format("'%s'", value);
    }

    private static String quoteIdentifier(String identifier) {
        return String.format("\"%s\"", identifier.replaceAll("\"", "\"\""));
    }
}

