/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.auth;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.pinot.auth.PinotAuthenticationType;
import io.trino.plugin.pinot.auth.PinotAuthenticationTypeConfig;
import io.trino.plugin.pinot.auth.PinotBrokerAuthenticationProvider;
import io.trino.plugin.pinot.auth.PinotControllerAuthenticationProvider;
import io.trino.plugin.pinot.auth.none.PinotEmptyAuthenticationProvider;
import io.trino.plugin.pinot.auth.password.PinotPasswordAuthenticationProvider;
import io.trino.plugin.pinot.auth.password.inline.PinotPasswordBrokerAuthenticationConfig;
import io.trino.plugin.pinot.auth.password.inline.PinotPasswordControllerAuthenticationConfig;

public class PinotAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationProviderModule(PinotAuthenticationType.NONE, new PinotNoneControllerAuthenticationProviderModule(), new PinotNoneBrokerAuthenticationProviderModule());
        this.bindAuthenticationProviderModule(PinotAuthenticationType.PASSWORD, new PinotPasswordControllerAuthenticationProviderModule(), new PinotPasswordBrokerAuthenticationProviderModule());
    }

    private void bindAuthenticationProviderModule(PinotAuthenticationType authType, Module controllerModule, Module brokerModule) {
        this.install(ConditionalModule.conditionalModule(PinotAuthenticationTypeConfig.class, config -> authType == config.getControllerAuthenticationType(), (Module)controllerModule));
        this.install(ConditionalModule.conditionalModule(PinotAuthenticationTypeConfig.class, config -> authType == config.getBrokerAuthenticationType(), (Module)brokerModule));
    }

    private static class PinotNoneControllerAuthenticationProviderModule
    implements Module {
        private PinotNoneControllerAuthenticationProviderModule() {
        }

        public void configure(Binder binder) {
        }

        @Provides
        @Singleton
        public PinotControllerAuthenticationProvider getAuthenticationProvider() {
            return PinotControllerAuthenticationProvider.create(PinotEmptyAuthenticationProvider.instance());
        }
    }

    private static class PinotNoneBrokerAuthenticationProviderModule
    implements Module {
        private PinotNoneBrokerAuthenticationProviderModule() {
        }

        public void configure(Binder binder) {
        }

        @Provides
        @Singleton
        public PinotBrokerAuthenticationProvider getAuthenticationProvider() {
            return PinotBrokerAuthenticationProvider.create(PinotEmptyAuthenticationProvider.instance());
        }
    }

    private static class PinotPasswordControllerAuthenticationProviderModule
    implements Module {
        private PinotPasswordControllerAuthenticationProviderModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PinotPasswordControllerAuthenticationConfig.class);
        }

        @Provides
        @Singleton
        public PinotControllerAuthenticationProvider getAuthenticationProvider(PinotPasswordControllerAuthenticationConfig config) {
            return PinotControllerAuthenticationProvider.create(new PinotPasswordAuthenticationProvider(config.getUser(), config.getPassword()));
        }
    }

    private static class PinotPasswordBrokerAuthenticationProviderModule
    implements Module {
        private PinotPasswordBrokerAuthenticationProviderModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PinotPasswordBrokerAuthenticationConfig.class);
        }

        @Provides
        @Singleton
        public PinotBrokerAuthenticationProvider getAuthenticationProvider(PinotPasswordBrokerAuthenticationConfig config) {
            return PinotBrokerAuthenticationProvider.create(new PinotPasswordAuthenticationProvider(config.getUser(), config.getPassword()));
        }
    }
}

