/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.spi.data.FieldSpec;

public class PinotTypeConverter {
    private final Supplier<Type> jsonTypeSupplier;

    @Inject
    public PinotTypeConverter(TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.jsonTypeSupplier = Suppliers.memoize(() -> typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0])));
    }

    public Type toTrinoType(FieldSpec field) {
        return this.toTrinoType(field.getDataType(), field.isSingleValueField());
    }

    public Type toTrinoType(TransformResultMetadata transformResultMetadata) {
        return this.toTrinoType(transformResultMetadata.getDataType(), transformResultMetadata.isSingleValue());
    }

    private Type toTrinoType(FieldSpec.DataType dataType, boolean isSingleValue) {
        Type type = this.toTrinoType(dataType);
        if (isSingleValue) {
            return type;
        }
        return new ArrayType(type);
    }

    private Type toTrinoType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case JSON: {
                return this.jsonTypeSupplier.get();
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP_MILLIS;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported type conversion for pinot data type: " + dataType);
    }

    public Type toTrinoType(DataSchema.ColumnDataType columnDataType) {
        switch (columnDataType) {
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case JSON: {
                return this.jsonTypeSupplier.get();
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case INT_ARRAY: {
                return new ArrayType((Type)IntegerType.INTEGER);
            }
            case LONG_ARRAY: {
                return new ArrayType((Type)BigintType.BIGINT);
            }
            case DOUBLE_ARRAY: {
                return new ArrayType((Type)DoubleType.DOUBLE);
            }
            case STRING_ARRAY: {
                return new ArrayType((Type)VarcharType.VARCHAR);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported column data type: " + columnDataType);
    }

    public boolean isJsonType(Type type) {
        Objects.requireNonNull(type, "type is null");
        return type.equals(this.jsonTypeSupplier.get());
    }
}

