/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Objects;
import java.util.Optional;

public class PinotException
extends TrinoException {
    private final boolean retryable;

    public PinotException(PinotErrorCode errorCode, Optional<String> query, String message) {
        this(errorCode, query, message, false, null);
    }

    public PinotException(PinotErrorCode errorCode, Optional<String> query, String message, boolean retryable) {
        this(errorCode, query, message, retryable, null);
    }

    public PinotException(PinotErrorCode errorCode, Optional<String> query, String message, Throwable throwable) {
        this(errorCode, query, message, false, throwable);
    }

    public PinotException(PinotErrorCode errorCode, Optional<String> query, String message, boolean retryable, Throwable throwable) {
        super((ErrorCodeSupplier)Objects.requireNonNull(errorCode, "errorCode is null"), PinotException.formatMessage(query, message), throwable);
        this.retryable = retryable;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    private static String formatMessage(Optional<String> query, String message) {
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(message, "message is null");
        if (query.isPresent()) {
            message = (String)message + " with query \"" + query.get() + "\"";
        }
        return message;
    }
}

