/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.HeapArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Util;

final class HeapArrayOfDoublesQuickSelectSketch
extends ArrayOfDoublesQuickSelectSketch {
    private final int nomEntries_;
    private final int lgResizeFactor_;
    private final float samplingProbability_;
    private int count_;
    private long[] keys_;
    private double[] values_;

    HeapArrayOfDoublesQuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, int numValues, long seed) {
        super(numValues, seed);
        this.nomEntries_ = nomEntries;
        this.lgResizeFactor_ = lgResizeFactor;
        this.samplingProbability_ = samplingProbability;
        this.theta_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        int startingCapacity = Util.getStartingCapacity(nomEntries, lgResizeFactor);
        this.keys_ = new long[startingCapacity];
        this.values_ = new double[startingCapacity * numValues];
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    HeapArrayOfDoublesQuickSelectSketch(Memory mem, long seed) {
        super(mem.getByte(5L), seed);
        boolean isBigEndian;
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(mem.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch);
        byte version = mem.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        byte flags = mem.getByte(4L);
        boolean bl = isBigEndian = (flags & 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(mem.getShort(6L), Util.computeSeedHash(seed));
        this.isEmpty_ = (flags & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) > 0;
        this.nomEntries_ = 1 << mem.getByte(16L);
        this.theta_ = mem.getLong(8L);
        int currentCapacity = 1 << mem.getByte(17L);
        this.lgResizeFactor_ = mem.getByte(18L);
        this.samplingProbability_ = mem.getFloat(20L);
        this.keys_ = new long[currentCapacity];
        this.values_ = new double[currentCapacity * this.numValues_];
        boolean hasEntries = (flags & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) > 0;
        int n = this.count_ = hasEntries ? mem.getInt(24L) : 0;
        if (this.count_ > 0) {
            mem.getLongArray(32L, this.keys_, 0, currentCapacity);
            mem.getDoubleArray(32L + 8L * (long)currentCapacity, this.values_, 0, currentCapacity * this.numValues_);
        }
        this.setRebuildThreshold();
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(currentCapacity);
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int i = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.keys_[j] == 0L) continue;
                values[i++] = Arrays.copyOfRange(this.values_, j * this.numValues_, (j + 1) * this.numValues_);
            }
        }
        return values;
    }

    @Override
    public int getRetainedEntries() {
        return this.count_;
    }

    @Override
    public int getNominalEntries() {
        return this.nomEntries_;
    }

    @Override
    public float getSamplingProbability() {
        return this.samplingProbability_;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.lgResizeFactor_);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getSerializedSizeBytes()];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        this.serializeInto(mem);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new HeapArrayOfDoublesSketchIterator(this.keys_, this.values_, this.numValues_);
    }

    @Override
    int getSerializedSizeBytes() {
        return 32 + (8 + 8 * this.numValues_) * this.getCurrentCapacity();
    }

    @Override
    void serializeInto(WritableMemory mem) {
        mem.putByte(0L, (byte)1);
        mem.putByte(1L, (byte)1);
        mem.putByte(2L, (byte)Family.TUPLE.getID());
        mem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        mem.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isInSamplingMode() ? 1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (this.count_ > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        mem.putByte(5L, (byte)this.numValues_);
        mem.putShort(6L, Util.computeSeedHash(this.seed_));
        mem.putLong(8L, this.theta_);
        mem.putByte(16L, (byte)Integer.numberOfTrailingZeros(this.nomEntries_));
        mem.putByte(17L, (byte)Integer.numberOfTrailingZeros(this.keys_.length));
        mem.putByte(18L, (byte)this.lgResizeFactor_);
        mem.putFloat(20L, this.samplingProbability_);
        mem.putInt(24L, this.count_);
        if (this.count_ > 0) {
            mem.putLongArray(32L, this.keys_, 0, this.keys_.length);
            mem.putDoubleArray(32L + 8L * (long)this.keys_.length, this.values_, 0, this.values_.length);
        }
    }

    @Override
    public void reset() {
        this.isEmpty_ = true;
        this.count_ = 0;
        this.theta_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        int startingCapacity = Util.getStartingCapacity(this.nomEntries_, this.lgResizeFactor_);
        this.keys_ = new long[startingCapacity];
        this.values_ = new double[startingCapacity * this.numValues_];
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    @Override
    protected long getKey(int index) {
        return this.keys_[index];
    }

    @Override
    protected void incrementCount() {
        ++this.count_;
    }

    @Override
    protected void setValues(int index, double[] values) {
        if (this.numValues_ == 1) {
            this.values_[index] = values[0];
        } else {
            System.arraycopy(values, 0, this.values_, index * this.numValues_, this.numValues_);
        }
    }

    @Override
    protected void updateValues(int index, double[] values) {
        if (this.numValues_ == 1) {
            int n = index;
            this.values_[n] = this.values_[n] + values[0];
        } else {
            int offset = index * this.numValues_;
            for (int i = 0; i < this.numValues_; ++i) {
                int n = offset + i;
                this.values_[n] = this.values_[n] + values[i];
            }
        }
    }

    @Override
    protected void setNotEmpty() {
        this.isEmpty_ = false;
    }

    @Override
    protected boolean isInSamplingMode() {
        return this.samplingProbability_ < 1.0f;
    }

    @Override
    protected void setThetaLong(long theta) {
        this.theta_ = theta;
    }

    @Override
    protected int getCurrentCapacity() {
        return this.keys_.length;
    }

    @Override
    protected void rebuild(int newCapacity) {
        long[] oldKeys = this.keys_;
        double[] oldValues = this.values_;
        this.keys_ = new long[newCapacity];
        this.values_ = new double[newCapacity * this.numValues_];
        this.count_ = 0;
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newCapacity);
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == 0L || oldKeys[i] >= this.theta_) continue;
            this.insert(oldKeys[i], Arrays.copyOfRange(oldValues, i * this.numValues_, (i + 1) * this.numValues_));
        }
        this.setRebuildThreshold();
    }

    @Override
    protected int insertKey(long key) {
        return HashOperations.hashInsertOnly(this.keys_, this.lgCurrentCapacity_, key);
    }

    @Override
    protected int findOrInsertKey(long key) {
        return HashOperations.hashSearchOrInsert(this.keys_, this.lgCurrentCapacity_, key);
    }

    @Override
    protected double[] find(long key) {
        int index = HashOperations.hashSearch(this.keys_, this.lgCurrentCapacity_, key);
        if (index == -1) {
            return null;
        }
        return Arrays.copyOfRange(this.values_, index * this.numValues_, (index + 1) * this.numValues_);
    }
}

