/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.fst;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class PinotBufferIndexInput
extends IndexInput {
    private final PinotDataBuffer _pinotDataBuffer;
    private final Long _sliceOffset;
    private final Long _length;
    private Long _readPointerOffset;

    public PinotBufferIndexInput(PinotDataBuffer pinotDataBuffer, Long offset, Long length) {
        super("");
        this._pinotDataBuffer = pinotDataBuffer;
        this._sliceOffset = offset;
        this._readPointerOffset = offset;
        this._length = length;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this._readPointerOffset;
    }

    public void seek(long l) throws IOException {
        this._readPointerOffset = this._sliceOffset + l;
    }

    public long length() {
        return this._length;
    }

    public IndexInput slice(String s, long l, long l1) throws IOException {
        return new PinotBufferIndexInput(this._pinotDataBuffer, this._sliceOffset + l, l1);
    }

    public byte readByte() throws IOException {
        Byte b = this._pinotDataBuffer.getByte(this._readPointerOffset.longValue());
        this._readPointerOffset = this._readPointerOffset + 1L;
        return b;
    }

    public void readBytes(byte[] bytes, int destOffset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            bytes[destOffset] = this.readByte();
            ++destOffset;
        }
    }
}

