/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.upsert.ConcurrentMapTableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUpsertMetadataManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableUpsertMetadataManagerFactory.class);

    private TableUpsertMetadataManagerFactory() {
    }

    public static TableUpsertMetadataManager create(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics) {
        TableUpsertMetadataManager metadataManager;
        String tableNameWithType = tableConfig.getTableName();
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null ? 1 : 0) != 0, (String)"Must provide upsert config for table: %s", (Object)tableNameWithType);
        String metadataManagerClass = upsertConfig.getMetadataManagerClass();
        if (StringUtils.isNotEmpty((CharSequence)metadataManagerClass)) {
            LOGGER.info("Creating TableUpsertMetadataManager with class: {} for table: {}", (Object)metadataManagerClass, (Object)tableNameWithType);
            try {
                metadataManager = (TableUpsertMetadataManager)Class.forName(metadataManagerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while constructing TableUpsertMetadataManager with class: %s for table: %s", metadataManagerClass, tableNameWithType), e);
            }
        } else {
            LOGGER.info("Creating ConcurrentMapTableUpsertMetadataManager for table: {}", (Object)tableNameWithType);
            metadataManager = new ConcurrentMapTableUpsertMetadataManager();
        }
        metadataManager.init(tableConfig, schema, tableDataManager, serverMetrics);
        return metadataManager;
    }
}

