/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.upsert.BasePartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

@ThreadSafe
public class ConcurrentMapPartitionUpsertMetadataManager
extends BasePartitionUpsertMetadataManager {
    @VisibleForTesting
    final ConcurrentHashMap<Object, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();
    private final GenericRow _reuse = new GenericRow();

    public ConcurrentMapPartitionUpsertMetadataManager(String tableNameWithType, int partitionId, List<String> primaryKeyColumns, String comparisonColumn, HashFunction hashFunction, @Nullable PartialUpsertHandler partialUpsertHandler, boolean enableSnapshot, ServerMetrics serverMetrics) {
        super(tableNameWithType, partitionId, primaryKeyColumns, comparisonColumn, hashFunction, partialUpsertHandler, enableSnapshot, serverMetrics);
    }

    @Override
    protected long getNumPrimaryKeys() {
        return this._primaryKeyToRecordLocationMap.size();
    }

    @Override
    protected void addOrReplaceSegment(ImmutableSegmentImpl segment, ThreadSafeMutableRoaringBitmap validDocIds, Iterator<RecordInfo> recordInfoIterator, @Nullable IndexSegment oldSegment, @Nullable MutableRoaringBitmap validDocIdsForOldSegment) {
        String segmentName = segment.getSegmentName();
        segment.enableUpsert(this, validDocIds);
        AtomicInteger numKeysInWrongSegment = new AtomicInteger();
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int comparisonResult = recordInfo.getComparisonValue().compareTo(currentRecordLocation.getComparisonValue());
                    if (currentSegment == segment) {
                        if (comparisonResult >= 0) {
                            validDocIds.replace(currentRecordLocation.getDocId(), recordInfo.getDocId());
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    if (currentSegment == oldSegment) {
                        if (comparisonResult >= 0) {
                            validDocIds.add(recordInfo.getDocId());
                            if (validDocIdsForOldSegment != null) {
                                validDocIdsForOldSegment.remove(currentRecordLocation.getDocId());
                            }
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    String currentSegmentName = currentSegment.getSegmentName();
                    if (currentSegmentName.equals(segmentName)) {
                        numKeysInWrongSegment.getAndIncrement();
                        if (comparisonResult >= 0) {
                            validDocIds.add(recordInfo.getDocId());
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    if (comparisonResult > 0 || comparisonResult == 0 && LLCSegmentName.isLowLevelConsumerSegmentName((String)segmentName) && LLCSegmentName.isLowLevelConsumerSegmentName((String)currentSegmentName) && LLCSegmentName.getSequenceNumber((String)segmentName) > LLCSegmentName.getSequenceNumber((String)currentSegmentName)) {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentRecordLocation.getDocId());
                        validDocIds.add(recordInfo.getDocId());
                        return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                    }
                    return currentRecordLocation;
                }
                validDocIds.add(recordInfo.getDocId());
                return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
            });
        }
        int numKeys = numKeysInWrongSegment.get();
        if (numKeys > 0) {
            this._logger.warn("Found {} primary keys in the wrong segment when adding segment: {}", (Object)numKeys, (Object)segmentName);
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.UPSERT_KEYS_IN_WRONG_SEGMENT, (long)numKeys);
        }
    }

    @Override
    protected void removeSegment(IndexSegment segment, MutableRoaringBitmap validDocIds) {
        assert (!validDocIds.isEmpty());
        PrimaryKey primaryKey = new PrimaryKey(new Object[this._primaryKeyColumns.size()]);
        PeekableIntIterator iterator = validDocIds.getIntIterator();
        try (UpsertUtils.PrimaryKeyReader primaryKeyReader = new UpsertUtils.PrimaryKeyReader(segment, this._primaryKeyColumns);){
            while (iterator.hasNext()) {
                primaryKeyReader.getPrimaryKey(iterator.next(), primaryKey);
                this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(primaryKey, this._hashFunction), (pk, recordLocation) -> {
                    if (recordLocation.getSegment() == segment) {
                        return null;
                    }
                    return recordLocation;
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while removing segment: %s, table: %s", segment.getSegmentName(), this._tableNameWithType), e);
        }
    }

    @Override
    public void addRecord(MutableSegment segment, RecordInfo recordInfo) {
        ThreadSafeMutableRoaringBitmap validDocIds = Objects.requireNonNull(segment.getValidDocIds());
        this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                if (recordInfo.getComparisonValue().compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int currentDocId = currentRecordLocation.getDocId();
                    if (segment == currentSegment) {
                        validDocIds.replace(currentDocId, recordInfo.getDocId());
                    } else {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentDocId);
                        validDocIds.add(recordInfo.getDocId());
                    }
                    return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                }
                return currentRecordLocation;
            }
            validDocIds.add(recordInfo.getDocId());
            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
        });
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    @Override
    public GenericRow updateRecord(GenericRow record, RecordInfo recordInfo) {
        if (this._partialUpsertHandler == null) {
            return record;
        }
        AtomicReference previousRecordReference = new AtomicReference();
        RecordLocation currentRecordLocation = this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (pk, recordLocation) -> {
            if (recordInfo.getComparisonValue().compareTo(recordLocation.getComparisonValue()) >= 0) {
                this._reuse.clear();
                previousRecordReference.set(recordLocation.getSegment().getRecord(recordLocation.getDocId(), this._reuse));
            }
            return recordLocation;
        });
        if (currentRecordLocation != null) {
            GenericRow previousRecord = (GenericRow)previousRecordReference.get();
            if (previousRecord != null) {
                return this._partialUpsertHandler.merge(previousRecord, record);
            }
            this.handleOutOfOrderEvent(currentRecordLocation.getComparisonValue(), recordInfo.getComparisonValue());
            return record;
        }
        return record;
    }

    @VisibleForTesting
    static class RecordLocation {
        private final IndexSegment _segment;
        private final int _docId;
        private final Comparable _comparisonValue;

        public RecordLocation(IndexSegment indexSegment, int docId, Comparable comparisonValue) {
            this._segment = indexSegment;
            this._docId = docId;
            this._comparisonValue = comparisonValue;
        }

        public IndexSegment getSegment() {
            return this._segment;
        }

        public int getDocId() {
            return this._docId;
        }

        public Comparable getComparisonValue() {
            return this._comparisonValue;
        }
    }
}

