/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.indexsegment.immutable.EmptyIndexSegment;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.config.table.HashFunction;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BasePartitionUpsertMetadataManager
implements PartitionUpsertMetadataManager {
    protected static final long OUT_OF_ORDER_EVENT_MIN_REPORT_INTERVAL_NS = TimeUnit.MINUTES.toNanos(1L);
    protected final String _tableNameWithType;
    protected final int _partitionId;
    protected final List<String> _primaryKeyColumns;
    protected final String _comparisonColumn;
    protected final HashFunction _hashFunction;
    protected final PartialUpsertHandler _partialUpsertHandler;
    protected final boolean _enableSnapshot;
    protected final ServerMetrics _serverMetrics;
    protected final Logger _logger;
    @VisibleForTesting
    public final Set<IndexSegment> _replacedSegments = ConcurrentHashMap.newKeySet();
    protected volatile boolean _closed = false;
    protected long _lastOutOfOrderEventReportTimeNs = Long.MIN_VALUE;
    protected int _numOutOfOrderEvents = 0;

    protected BasePartitionUpsertMetadataManager(String tableNameWithType, int partitionId, List<String> primaryKeyColumns, String comparisonColumn, HashFunction hashFunction, @Nullable PartialUpsertHandler partialUpsertHandler, boolean enableSnapshot, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableNameWithType;
        this._partitionId = partitionId;
        this._primaryKeyColumns = primaryKeyColumns;
        this._comparisonColumn = comparisonColumn;
        this._hashFunction = hashFunction;
        this._partialUpsertHandler = partialUpsertHandler;
        this._enableSnapshot = enableSnapshot;
        this._serverMetrics = serverMetrics;
        this._logger = LoggerFactory.getLogger((String)(tableNameWithType + "-" + partitionId + "-" + this.getClass().getSimpleName()));
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    @Override
    public void addSegment(ImmutableSegment segment) {
        MutableRoaringBitmap validDocIds;
        String segmentName = segment.getSegmentName();
        this._logger.info("Adding segment: {}, current primary key count: {}", (Object)segmentName, (Object)this.getNumPrimaryKeys());
        if (segment instanceof EmptyIndexSegment) {
            this._logger.info("Skip adding empty segment: {}", (Object)segmentName);
            return;
        }
        Preconditions.checkArgument((boolean)(segment instanceof ImmutableSegmentImpl), (String)"Got unsupported segment implementation: {} for segment: {}, table: {}", segment.getClass(), (Object)segmentName, (Object)this._tableNameWithType);
        ImmutableSegmentImpl immutableSegmentImpl = (ImmutableSegmentImpl)segment;
        if (this._enableSnapshot) {
            validDocIds = immutableSegmentImpl.loadValidDocIdsFromSnapshot();
            if (validDocIds != null && validDocIds.isEmpty()) {
                this._logger.info("Skip adding segment: {} without valid doc, current primary key count: {}", (Object)segment.getSegmentName(), (Object)this.getNumPrimaryKeys());
                return;
            }
        } else {
            validDocIds = null;
            immutableSegmentImpl.deleteValidDocIdsSnapshot();
        }
        try (UpsertUtils.RecordInfoReader recordInfoReader = new UpsertUtils.RecordInfoReader((IndexSegment)segment, this._primaryKeyColumns, this._comparisonColumn);){
            Iterator<RecordInfo> recordInfoIterator = validDocIds != null ? UpsertUtils.getRecordInfoIterator(recordInfoReader, validDocIds) : UpsertUtils.getRecordInfoIterator(recordInfoReader, segment.getSegmentMetadata().getTotalDocs());
            this.addSegment(immutableSegmentImpl, null, recordInfoIterator);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while adding segment: %s, table: %s", segmentName, this._tableNameWithType), e);
        }
        long numPrimaryKeys = this.getNumPrimaryKeys();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, numPrimaryKeys);
        this._logger.info("Finished adding segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addSegment(ImmutableSegmentImpl segment, @Nullable ThreadSafeMutableRoaringBitmap validDocIds, Iterator<RecordInfo> recordInfoIterator) {
        String segmentName = segment.getSegmentName();
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            if (validDocIds == null) {
                validDocIds = new ThreadSafeMutableRoaringBitmap();
            }
            this.addOrReplaceSegment(segment, validDocIds, recordInfoIterator, null, null);
        }
        finally {
            segmentLock.unlock();
        }
    }

    protected abstract long getNumPrimaryKeys();

    protected abstract void addOrReplaceSegment(ImmutableSegmentImpl var1, ThreadSafeMutableRoaringBitmap var2, Iterator<RecordInfo> var3, @Nullable IndexSegment var4, @Nullable MutableRoaringBitmap var5);

    @Override
    public void replaceSegment(ImmutableSegment segment, IndexSegment oldSegment) {
        String segmentName = segment.getSegmentName();
        Preconditions.checkArgument((boolean)segmentName.equals(oldSegment.getSegmentName()), (String)"Cannot replace segment with different name for table: {}, old segment: {}, new segment: {}", (Object)this._tableNameWithType, (Object)oldSegment.getSegmentName(), (Object)segmentName);
        this._logger.info("Replacing {} segment: {}, current primary key count: {}", new Object[]{oldSegment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this.getNumPrimaryKeys()});
        if (segment instanceof EmptyIndexSegment) {
            this._logger.info("Skip adding empty segment: {}", (Object)segmentName);
            this.replaceSegment(segment, null, null, oldSegment);
            return;
        }
        try (UpsertUtils.RecordInfoReader recordInfoReader = new UpsertUtils.RecordInfoReader((IndexSegment)segment, this._primaryKeyColumns, this._comparisonColumn);){
            Iterator<RecordInfo> recordInfoIterator = UpsertUtils.getRecordInfoIterator(recordInfoReader, segment.getSegmentMetadata().getTotalDocs());
            this.replaceSegment(segment, null, recordInfoIterator, oldSegment);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while replacing segment: %s, table: %s", segmentName, this._tableNameWithType), e);
        }
        long numPrimaryKeys = this.getNumPrimaryKeys();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, numPrimaryKeys);
        this._logger.info("Finished replacing segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void replaceSegment(ImmutableSegment segment, @Nullable ThreadSafeMutableRoaringBitmap validDocIds, @Nullable Iterator<RecordInfo> recordInfoIterator, IndexSegment oldSegment) {
        String segmentName = segment.getSegmentName();
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            MutableRoaringBitmap validDocIdsForOldSegment;
            MutableRoaringBitmap mutableRoaringBitmap = validDocIdsForOldSegment = oldSegment.getValidDocIds() != null ? oldSegment.getValidDocIds().getMutableRoaringBitmap() : null;
            if (recordInfoIterator != null) {
                Preconditions.checkArgument((boolean)(segment instanceof ImmutableSegmentImpl), (String)"Got unsupported segment implementation: {} for segment: {}, table: {}", segment.getClass(), (Object)segmentName, (Object)this._tableNameWithType);
                if (validDocIds == null) {
                    validDocIds = new ThreadSafeMutableRoaringBitmap();
                }
                this.addOrReplaceSegment((ImmutableSegmentImpl)segment, validDocIds, recordInfoIterator, oldSegment, validDocIdsForOldSegment);
            }
            if (validDocIdsForOldSegment != null && !validDocIdsForOldSegment.isEmpty()) {
                int numKeysNotReplaced = validDocIdsForOldSegment.getCardinality();
                if (this._partialUpsertHandler != null) {
                    this._logger.warn("Found {} primary keys not replaced when replacing segment: {} for partial-upsert table. This can potentially cause inconsistency between replicas", (Object)numKeysNotReplaced, (Object)segmentName);
                    this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.PARTIAL_UPSERT_KEYS_NOT_REPLACED, (long)numKeysNotReplaced);
                } else {
                    this._logger.info("Found {} primary keys not replaced when replacing segment: {}", (Object)numKeysNotReplaced, (Object)segmentName);
                }
                this.removeSegment(oldSegment, validDocIdsForOldSegment);
            }
        }
        finally {
            segmentLock.unlock();
        }
        if (!(oldSegment instanceof EmptyIndexSegment)) {
            this._replacedSegments.add(oldSegment);
        }
    }

    protected abstract void removeSegment(IndexSegment var1, MutableRoaringBitmap var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSegment(IndexSegment segment) {
        String segmentName = segment.getSegmentName();
        this._logger.info("Removing {} segment: {}, current primary key count: {}", new Object[]{segment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this.getNumPrimaryKeys()});
        if (this._replacedSegments.remove(segment)) {
            this._logger.info("Skip removing replaced segment: {}", (Object)segmentName);
            return;
        }
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            MutableRoaringBitmap validDocIds;
            MutableRoaringBitmap mutableRoaringBitmap = validDocIds = segment.getValidDocIds() != null ? segment.getValidDocIds().getMutableRoaringBitmap() : null;
            if (this._enableSnapshot && segment instanceof ImmutableSegmentImpl && validDocIds != null) {
                ((ImmutableSegmentImpl)segment).persistValidDocIdsSnapshot(validDocIds);
            }
            if (this._closed) {
                this._logger.info("Skip removing segment: {} because metadata manager is already closed", (Object)segment);
                return;
            }
            if (validDocIds == null || validDocIds.isEmpty()) {
                this._logger.info("Skip removing segment without valid docs: {}", (Object)segmentName);
                return;
            }
            this._logger.info("Removing {} primary keys for segment: {}", (Object)validDocIds.getCardinality(), (Object)segmentName);
            this.removeSegment(segment, validDocIds);
        }
        finally {
            segmentLock.unlock();
        }
        long numPrimaryKeys = this.getNumPrimaryKeys();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, numPrimaryKeys);
        this._logger.info("Finished removing segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    protected void handleOutOfOrderEvent(Object currentComparisonValue, Object recordComparisonValue) {
        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.PARTIAL_UPSERT_OUT_OF_ORDER, 1L);
        ++this._numOutOfOrderEvents;
        long currentTimeNs = System.nanoTime();
        if (currentTimeNs - this._lastOutOfOrderEventReportTimeNs > OUT_OF_ORDER_EVENT_MIN_REPORT_INTERVAL_NS) {
            this._logger.warn("Skipped {} out-of-order events for partial-upsert table (the last event has current comparison value: {}, record comparison value: {})", new Object[]{this._numOutOfOrderEvents, currentComparisonValue, recordComparisonValue});
            this._lastOutOfOrderEventReportTimeNs = currentTimeNs;
            this._numOutOfOrderEvents = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this._logger.info("Closing the metadata manager, current primary key count: {}", (Object)this.getNumPrimaryKeys());
        this._closed = true;
    }
}

